/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.compiler.Bits;
import io.brackit.query.compiler.Unit;
import io.brackit.query.expr.Variable;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.sequence.TypedSequence;

public class DefaultCtxItem
extends Variable
implements Unit {
    private Expr expr;
    private ItemType type = AnyItemType.ANY;
    private boolean external = true;
    private Item item;

    public DefaultCtxItem() {
        super(Bits.FS_DOT);
    }

    @Override
    public void setExpr(Expr expr) {
        this.expr = expr;
    }

    public void setType(ItemType type) {
        this.type = type;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        if (this.item != null) {
            return this.item;
        }
        Item i = null;
        if (this.external) {
            i = ctx.getContextItem();
        }
        if (i == null && this.expr != null) {
            i = this.expr.evaluateToItem(ctx, tuple);
        }
        if (i == null) {
            throw new QueryException(ErrorCode.ERR_DYNAMIC_CONTEXT_VARIABLE_NOT_DEFINED, "Dynamic context variable %s is not assigned a value", this.name);
        }
        this.item = TypedSequence.toTypedItem(new SequenceType(this.type, Cardinality.One), i);
        return i;
    }
}

