/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.Bits;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.ItemSequence;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.ExprUtil;

public class DerefExpr
implements Expr {
    final Expr object;
    final Expr field;

    public DerefExpr(Expr object, Expr field) {
        this.object = object;
        this.field = field;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence sequence = this.object.evaluate(ctx, tuple);
        if (sequence instanceof ItemSequence) {
            ItemSequence itemSequence = (ItemSequence)sequence;
            return this.getLazySequence(ctx, tuple, itemSequence.iterate());
        }
        if (sequence instanceof LazySequence) {
            LazySequence lazySequence = (LazySequence)sequence;
            return this.getLazySequence(ctx, tuple, lazySequence.iterate());
        }
        if (!(sequence instanceof Object)) {
            return null;
        }
        Object obj = (Object)sequence;
        Item itemField = this.field.evaluateToItem(ctx, tuple);
        if (itemField == null) {
            return null;
        }
        return this.getSequenceByRecordField(obj, itemField);
    }

    private LazySequence getLazySequence(final QueryContext ctx, final Tuple tuple, final Iter iter) {
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){

                    @Override
                    public Item next() {
                        Item item;
                        while ((item = iter.next()) != null) {
                            Sequence sequenceByRecordField;
                            if (!(item instanceof Object)) continue;
                            Object obj = (Object)item;
                            Item itemField = DerefExpr.this.field.evaluateToItem(ctx, tuple);
                            if (itemField == null || (sequenceByRecordField = DerefExpr.this.getSequenceByRecordField(obj, itemField)) == null) continue;
                            return sequenceByRecordField.evaluateToItem(ctx, tuple);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                        iter.close();
                    }
                };
            }
        };
    }

    private Sequence getSequenceByRecordField(Object object, Item itemField) {
        if (itemField instanceof QNm) {
            QNm qNmField = (QNm)itemField;
            return object.get(qNmField);
        }
        if (itemField instanceof IntNumeric) {
            IntNumeric intNumericField = (IntNumeric)itemField;
            return object.value(intNumericField);
        }
        if (itemField instanceof Atomic) {
            Atomic atomicField = (Atomic)itemField;
            return object.get(new QNm(atomicField.stringValue()));
        }
        throw new QueryException(Bits.BIT_ILLEGAL_OBJECT_FIELD, "Illegal object itemField reference: %s", itemField);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        if (this.object.isUpdating()) {
            return true;
        }
        return this.field.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return "." + String.valueOf(this.field);
    }
}

