/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.expr.PredicateExpr;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.ExprUtil;
import java.util.Arrays;

public class FilterExpr
extends PredicateExpr {
    final Expr expr;

    public FilterExpr(Expr expr, Expr[] filter, boolean[] bindItem, boolean[] bindPos, boolean[] bindSize) {
        super(filter, bindItem, bindPos, bindSize);
        this.expr = expr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence s = this.expr.evaluate(ctx, tuple);
        for (int i = 0; i < this.filter.length; ++i) {
            if (s == null) {
                return null;
            }
            if (this.bindCount[i] == 0) {
                Sequence fs = this.filter[i].evaluate(ctx, tuple);
                if (fs == null) {
                    return null;
                }
                if (fs instanceof Numeric) {
                    IntNumeric pos = ((Numeric)fs).asIntNumeric();
                    s = pos != null ? s.get(pos) : null;
                    continue;
                }
                try (Iter it = fs.iterate();){
                    Item first = it.next();
                    if (first != null && it.next() == null && first instanceof Numeric) {
                        IntNumeric pos = ((Numeric)first).asIntNumeric();
                        Item item = pos != null ? s.get(pos) : null;
                        return item;
                    }
                }
                if (fs.booleanValue()) continue;
                return null;
            }
            s = new PredicateExpr.DependentFilterSeq(this, ctx, tuple, s, i);
        }
        return s;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence s = this.expr.evaluate(ctx, tuple);
        for (int i = 0; i < this.filter.length; ++i) {
            if (s == null) {
                return null;
            }
            if (s instanceof Item) {
                Sequence fRes;
                Tuple current = tuple;
                if (this.bindCount[i] > 0) {
                    Sequence[] tmp = new Sequence[this.bindCount[i]];
                    int p = 0;
                    if (this.bindItem[i]) {
                        tmp[p++] = s;
                    }
                    if (this.bindPos[i]) {
                        tmp[p++] = Int32.ONE;
                    }
                    if (this.bindSize[i]) {
                        tmp[p] = Int32.ONE;
                    }
                    current = current.concat(tmp);
                }
                if ((fRes = this.filter[i].evaluate(ctx, current)) == null) {
                    return null;
                }
                if (fRes instanceof Numeric && ((Numeric)fRes).intValue() != 1) {
                    return null;
                }
                if (fRes.booleanValue()) continue;
                return null;
            }
            s = ExprUtil.asItem(this.evaluate(ctx, tuple));
        }
        return (Item)s;
    }

    @Override
    public boolean isUpdating() {
        if (this.expr.isUpdating()) {
            return true;
        }
        return super.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return this.expr.toString() + "[" + Arrays.toString(this.filter) + "]";
    }
}

