/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.expr.VCmpExpr;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.Cmp;

public class GCmpExpr
extends VCmpExpr {
    public GCmpExpr(Cmp cmp, Expr leftExpr, Expr rightExpr) {
        super(cmp, leftExpr, rightExpr);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence left = this.leftExpr.evaluate(ctx, tuple);
        Sequence right = this.rightExpr.evaluate(ctx, tuple);
        return this.cmp.gCmpAsBool(ctx, left, right);
    }

    @Override
    public String toString() {
        return String.valueOf(this.leftExpr) + " " + this.toGcmpString(this.cmp) + " " + String.valueOf(this.rightExpr);
    }

    private String toGcmpString(Cmp cmp) {
        return switch (cmp) {
            default -> throw new IncompatibleClassChangeError();
            case Cmp.eq -> "=";
            case Cmp.ne -> "!=";
            case Cmp.ge -> ">=";
            case Cmp.gt -> ">";
            case Cmp.le -> "<=";
            case Cmp.lt -> "<";
        };
    }
}

