/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.sequence.SortedNodeSequence;
import io.brackit.query.util.ExprUtil;
import java.util.Comparator;

public class IntersectExpr
implements Expr {
    private final Expr firstExpr;
    private final Expr secondExpr;

    public IntersectExpr(Expr firstExpr, Expr secondExpr) {
        this.firstExpr = firstExpr;
        this.secondExpr = secondExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence sequenceA = this.firstExpr.evaluate(ctx, tuple);
        Sequence sequenceB = this.secondExpr.evaluate(ctx, tuple);
        if (sequenceA == null || sequenceB == null) {
            return null;
        }
        Comparator comparator = (o1, o2) -> ((Node)o1).cmp((Node)o2);
        final SortedNodeSequence sortedA = new SortedNodeSequence(comparator, sequenceA, true);
        final SortedNodeSequence sortedB = new SortedNodeSequence(comparator, sequenceB, true);
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    Iter aIt;
                    Iter bIt;
                    Node<?> a;
                    Node<?> b;

                    @Override
                    public Item next() {
                        if (this.aIt == null) {
                            this.aIt = sortedA.iterate();
                            this.bIt = sortedB.iterate();
                            this.a = (Node)this.aIt.next();
                            this.b = (Node)this.bIt.next();
                        }
                        while (this.a != null && this.b != null) {
                            int res = this.a.cmp(this.b);
                            if (res == 0) {
                                Node<?> deliver = this.a;
                                this.a = (Node)this.aIt.next();
                                return deliver;
                            }
                            if (res < 0) {
                                this.a = (Node)this.aIt.next();
                                continue;
                            }
                            this.b = (Node)this.bIt.next();
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                        if (this.aIt != null) {
                            this.aIt.close();
                        }
                        if (this.bIt != null) {
                            this.bIt.close();
                        }
                    }
                };
            }
        };
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.firstExpr.isUpdating() || this.secondExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

