/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;

public abstract class PredicateExpr
implements Expr {
    protected final Expr[] filter;
    protected final boolean[] bindItem;
    protected final boolean[] bindPos;
    protected final boolean[] bindSize;
    protected final int[] bindCount;

    public PredicateExpr(Expr[] filter, boolean[] bindItem, boolean[] bindPos, boolean[] bindSize) {
        this.filter = filter;
        this.bindItem = bindItem;
        this.bindPos = bindPos;
        this.bindSize = bindSize;
        this.bindCount = new int[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            this.bindCount[i] = (bindItem[i] ? 1 : 0) + (bindPos[i] ? 1 : 0) + (bindSize[i] ? 1 : 0);
        }
    }

    @Override
    public boolean isUpdating() {
        for (Expr e : this.filter) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    protected class DependentFilterSeq
    extends LazySequence {
        private final QueryContext ctx;
        private final Tuple tuple;
        private final Sequence s;
        private final int i;
        private final IntNumeric inSeqSize;

        public DependentFilterSeq(QueryContext ctx, Tuple tuple, Sequence s, int i) {
            this.ctx = ctx;
            this.tuple = tuple;
            this.s = s;
            this.i = i;
            this.inSeqSize = PredicateExpr.this.bindSize[i] ? (s != null ? s.size() : Int32.ZERO) : Int32.ONE;
        }

        @Override
        public Iter iterate() {
            return new BaseIter(){
                IntNumeric pos;
                Iter it;

                @Override
                public Item next() {
                    Item n;
                    if (this.pos == null) {
                        if (DependentFilterSeq.this.s instanceof Item) {
                            this.pos = Int32.ONE;
                            if (this.predicate((Item)DependentFilterSeq.this.s)) {
                                return (Item)DependentFilterSeq.this.s;
                            }
                            return null;
                        }
                        if (DependentFilterSeq.this.s != null) {
                            this.pos = Int32.ZERO;
                            this.it = DependentFilterSeq.this.s.iterate();
                        }
                    }
                    if (this.it == null) {
                        return null;
                    }
                    while ((n = this.it.next()) != null) {
                        this.pos = this.pos.inc();
                        if (!this.predicate(n)) continue;
                        return n;
                    }
                    this.it.close();
                    return null;
                }

                private boolean predicate(Item item) {
                    Sequence res;
                    Tuple current = DependentFilterSeq.this.tuple;
                    if (PredicateExpr.this.bindCount[DependentFilterSeq.this.i] > 0) {
                        Sequence[] tmp = new Sequence[PredicateExpr.this.bindCount[DependentFilterSeq.this.i]];
                        int p = 0;
                        if (PredicateExpr.this.bindItem[DependentFilterSeq.this.i]) {
                            tmp[p++] = item;
                        }
                        if (PredicateExpr.this.bindPos[DependentFilterSeq.this.i]) {
                            tmp[p++] = this.pos;
                        }
                        if (PredicateExpr.this.bindSize[DependentFilterSeq.this.i]) {
                            tmp[p] = DependentFilterSeq.this.inSeqSize;
                        }
                        current = current.concat(tmp);
                    }
                    if ((res = PredicateExpr.this.filter[DependentFilterSeq.this.i].evaluate(DependentFilterSeq.this.ctx, current)) == null) {
                        return false;
                    }
                    if (res instanceof Numeric) {
                        return ((Numeric)res).cmp(this.pos) == 0;
                    }
                    try (Iter it = res.iterate();){
                        Item first = it.next();
                        if (first != null && it.next() == null && first instanceof Numeric && ((Numeric)first).cmp(this.pos) != 0) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    return res.booleanValue();
                }

                @Override
                public void close() {
                    if (this.it != null) {
                        this.it.close();
                    }
                }
            };
        }
    }
}

