/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.ErrorCode;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.Bits;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.jsonitem.object.ArrayObject;

public final class ProjectionExpr
implements Expr {
    private final Expr record;
    private final Expr[] fields;

    public ProjectionExpr(Expr record, Expr[] fields) {
        this.record = record;
        this.fields = fields;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        return this.evaluateToItem(ctx, t);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) {
        Item s = this.record.evaluateToItem(ctx, t);
        if (!(s instanceof Object)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Source expression in projection is not a record: %s", s);
        }
        Object r = (Object)s;
        QNm[] names = new QNm[this.fields.length];
        Sequence[] vals = new Sequence[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            Item f = this.fields[i].evaluateToItem(ctx, t);
            if (f == null) {
                return null;
            }
            if (f instanceof QNm) {
                names[i] = (QNm)f;
                vals[i] = r.get((QNm)f);
                continue;
            }
            if (f instanceof IntNumeric) {
                names[i] = r.name(i);
                vals[i] = r.value((IntNumeric)f);
                continue;
            }
            if (f instanceof Atomic) {
                QNm name;
                names[i] = name = new QNm(((Atomic)f).asStr().toString());
                vals[i] = r.get(name);
                continue;
            }
            throw new QueryException(Bits.BIT_ILLEGAL_OBJECT_FIELD, "Illegal record field reference: %s", f);
        }
        return new ArrayObject(names, vals);
    }

    @Override
    public boolean isUpdating() {
        if (this.record.isUpdating()) {
            return true;
        }
        for (Expr f : this.fields) {
            if (!f.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Expr f : this.fields) {
            s.append("=>");
            s.append(f);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        new Query("let $a:= 1 let $b:= {'b':2.0} let $n := <x><y>yval</y></x> return {a:$a, $b, c:'3'}{a,c}=>c").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }
}

