/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;

public class StringConcatExpr
implements Expr {
    private final Expr[] exprs;

    public StringConcatExpr(Expr[] exprs) {
        this.exprs = exprs;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Expr expr : this.exprs) {
            Item item = expr.evaluateToItem(ctx, tuple);
            if (item == null) continue;
            stringBuilder.append(item.atomize().asStr());
        }
        return new Str(stringBuilder.toString());
    }

    @Override
    public boolean isUpdating() {
        for (Expr expr : this.exprs) {
            if (!expr.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

