/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.sequence.AbstractSequence;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.TypedSequence;

public class Treat
implements Expr {
    private final Expr expr;
    private final SequenceType expected;

    public Treat(Expr expr, SequenceType expected) {
        this.expr = expr;
        this.expected = expected;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        try {
            Sequence sequence = this.expr.evaluate(ctx, tuple);
            final Sequence typedSequence = TypedSequence.toTypedSequence(this.expected, sequence);
            return new AbstractSequence(){
                final Sequence s;
                {
                    this.s = typedSequence;
                }

                @Override
                public IntNumeric size() {
                    try {
                        return this.s.size();
                    }
                    catch (QueryException e) {
                        if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                            throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                        }
                        throw e;
                    }
                }

                @Override
                public Iter iterate() {
                    return new BaseIter(){
                        Iter it;
                        {
                            this.it = s.iterate();
                        }

                        @Override
                        public Item next() {
                            try {
                                return this.it.next();
                            }
                            catch (QueryException e) {
                                if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                                    throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                                }
                                throw e;
                            }
                        }

                        @Override
                        public void close() {
                            this.it.close();
                        }
                    };
                }

                @Override
                public boolean booleanValue() {
                    try {
                        return this.s.booleanValue();
                    }
                    catch (QueryException e) {
                        if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                            throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                        }
                        throw e;
                    }
                }

                @Override
                public Item get(IntNumeric pos) {
                    try {
                        return this.s.get(pos);
                    }
                    catch (QueryException e) {
                        if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                            throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                        }
                        throw e;
                    }
                }
            };
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
            }
            throw e;
        }
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        try {
            Item item = this.expr.evaluateToItem(ctx, tuple);
            return TypedSequence.toTypedItem(this.expected, item);
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
            }
            throw e;
        }
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

