/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;

public class TypeswitchExpr
implements Expr {
    private final Expr operandExpr;
    private final Expr[] caseExprs;
    private final SequenceType[] caseTypes;
    private final boolean[] varRefs;
    private final Expr defaultExpr;
    private final boolean updating;
    private final boolean vacuous;

    public TypeswitchExpr(Expr operandExpr, Expr[] caseExprs, SequenceType[] caseTypes, boolean[] varRefs, Expr defaultExpr, boolean updating, boolean vacuous) {
        this.operandExpr = operandExpr;
        this.caseExprs = caseExprs;
        this.caseTypes = caseTypes;
        this.varRefs = varRefs;
        this.defaultExpr = defaultExpr;
        this.updating = updating;
        this.vacuous = vacuous;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluate(ctx, tuple, false);
    }

    private Sequence evaluate(QueryContext ctx, Tuple tuple, boolean toItem) {
        Sequence operand = this.operandExpr.evaluate(ctx, tuple);
        for (int i = 0; i < this.caseExprs.length; ++i) {
            ItemType itemType = this.caseTypes[i].getItemType();
            Cardinality card = this.caseTypes[i].getCardinality();
            Iter it = operand.iterate();
            Item item = it.next();
            if (item == null) {
                if (card == Cardinality.One || card == Cardinality.OneOrMany) continue;
                if (toItem) {
                    return this.caseExprs[i].evaluateToItem(ctx, this.varRefs[i] ? tuple.concat(operand) : tuple);
                }
                return this.caseExprs[i].evaluate(ctx, this.varRefs[i] ? tuple.concat(operand) : tuple);
            }
            if (card == Cardinality.Zero || !itemType.matches(item) || (item = it.next()) != null && (card == Cardinality.One || card == Cardinality.ZeroOrOne || !itemType.matches(item))) continue;
            if (item != null && itemType != AnyItemType.ANY) {
                boolean match = true;
                while ((item = it.next()) != null) {
                    if (itemType.matches(item)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
            }
            if (toItem) {
                return this.caseExprs[i].evaluateToItem(ctx, this.varRefs[i] ? tuple.concat(operand) : tuple);
            }
            return this.caseExprs[i].evaluate(ctx, this.varRefs[i] ? tuple.concat(operand) : tuple);
        }
        if (toItem) {
            return this.defaultExpr.evaluateToItem(ctx, this.varRefs[this.varRefs.length - 1] ? tuple.concat(operand) : tuple);
        }
        return this.defaultExpr.evaluate(ctx, this.varRefs[this.varRefs.length - 1] ? tuple.concat(operand) : tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return (Item)this.evaluate(ctx, tuple, true);
    }

    @Override
    public boolean isUpdating() {
        return this.updating;
    }

    @Override
    public boolean isVacuous() {
        return this.vacuous;
    }
}

