/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.Bits;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Function;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.FunctionConversionSequence;
import io.brackit.query.sequence.ItemSequence;
import io.brackit.query.util.ExprUtil;
import org.magicwerk.brownies.collections.GapList;

public class DynamicFunctionExpr
implements Expr {
    private final StaticContext sctx;
    private final Expr functionExpr;
    private final Expr[] arguments;

    public DynamicFunctionExpr(StaticContext sctx, Expr function, Expr ... exprs) {
        this.sctx = sctx;
        this.functionExpr = function;
        this.arguments = exprs;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Item functionItem = this.functionExpr.evaluateToItem(ctx, tuple);
        int argumentsSize = this.arguments.length;
        if (functionItem instanceof Array) {
            Array array = (Array)functionItem;
            if (argumentsSize == 0) {
                Item item;
                Iter it = array.iterate();
                GapList buffer = new GapList(array.len());
                while ((item = it.next()) != null) {
                    buffer.add((Object)item);
                }
                return new ItemSequence((Item[])buffer.toArray((Object[])new Item[0]));
            }
            if (argumentsSize == 1) {
                Item indexItem = this.arguments[0].evaluateToItem(ctx, tuple);
                if (!(indexItem instanceof IntNumeric)) {
                    throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", indexItem.itemType(), Type.INR);
                }
                int index = ((IntNumeric)indexItem).intValue();
                return array.at(index);
            }
            throw new QueryException(new QNm(""));
        }
        if (functionItem instanceof io.brackit.query.jdm.json.Object) {
            io.brackit.query.jdm.json.Object object = (io.brackit.query.jdm.json.Object)functionItem;
            if (argumentsSize == 0) {
                Array names = object.names();
                GapList buffer = new GapList(names.len());
                for (int i = 0; i < names.len(); ++i) {
                    buffer.add((Object)names.at(i).evaluateToItem(ctx, tuple));
                }
                return new ItemSequence((Item[])buffer.toArray((Object[])new Item[0]));
            }
            if (argumentsSize == 1) {
                Item fieldItem = this.arguments[0].evaluateToItem(ctx, tuple);
                return this.getSequenceByObjectField(object, fieldItem);
            }
            throw new QueryException(new QNm(""));
        }
        if (functionItem instanceof Function) {
            Sequence res;
            Sequence[] args;
            Function function = (Function)functionItem;
            int pos = 0;
            for (Sequence sequence : tuple.array()) {
                if (sequence == functionItem) break;
                ++pos;
            }
            ItemType dftCtxItemType = function.getSignature().defaultCtxItemType();
            SequenceType dftCtxType = dftCtxItemType != null ? new SequenceType(dftCtxItemType, Cardinality.One) : null;
            if (dftCtxType != null) {
                Item ctxItem = this.arguments[0].evaluateToItem(ctx, tuple);
                FunctionConversionSequence.asTypedSequence(dftCtxType, ctxItem, false);
                args = new Sequence[]{ctxItem};
            } else {
                int i;
                SequenceType[] params = function.getSignature().getParams();
                args = new Sequence[this.arguments.length + pos];
                for (i = 0; i < pos; ++i) {
                    args[i] = tuple.get(i);
                }
                for (i = 0; i < this.arguments.length; ++i) {
                    SequenceType sType;
                    SequenceType sequenceType = sType = i < params.length ? params[i] : params[params.length - 1];
                    if (sType.getCardinality().many()) {
                        args[pos + i] = this.arguments[i].evaluate(ctx, tuple);
                        if (sType.getItemType().isAnyItem()) continue;
                        args[pos + i] = FunctionConversionSequence.asTypedSequence(sType, args[i], false);
                        continue;
                    }
                    args[pos + i] = this.arguments[i].evaluateToItem(ctx, tuple);
                    args[pos + i] = FunctionConversionSequence.asTypedSequence(sType, args[i], false);
                }
            }
            try {
                res = function.execute(this.sctx, ctx, args);
            }
            catch (StackOverflowError e) {
                throw new QueryException(e, ErrorCode.BIT_DYN_RT_STACK_OVERFLOW, "Execution of function '%s' was aborted because of too deep recursion.", function.getName());
            }
            if (function.isBuiltIn()) {
                return res;
            }
            res = FunctionConversionSequence.asTypedSequence(function.getSignature().getResultType(), res, false);
            return ExprUtil.materialize(res);
        }
        throw new QueryException(new QNm(""));
    }

    private Sequence getSequenceByObjectField(io.brackit.query.jdm.json.Object object, Item itemField) {
        if (itemField instanceof QNm) {
            QNm qNmField = (QNm)itemField;
            return object.get(qNmField);
        }
        if (itemField instanceof IntNumeric) {
            IntNumeric intNumericField = (IntNumeric)itemField;
            return object.value(intNumericField);
        }
        if (itemField instanceof Atomic) {
            Atomic atomicField = (Atomic)itemField;
            return object.get(new QNm(atomicField.stringValue()));
        }
        throw new QueryException(Bits.BIT_ILLEGAL_OBJECT_FIELD, "Illegal object itemField reference: %s", itemField);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.functionExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return this.functionExpr.toString();
    }
}

