/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.QueryContext;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.type.ArrayType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.operator.TupleImpl;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.FlatteningSequence;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.annotation.FunctionAnnotation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

@FunctionAnnotation(description="Returns the values of the given array.", parameters={"$array"})
public class ArrayValues
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "array-values");

    public ArrayValues() {
        this(DEFAULT_NAME);
    }

    public ArrayValues(QNm name) {
        super(name, new Signature(SequenceType.ITEM_SEQUENCE, new SequenceType(ArrayType.ARRAY, Cardinality.ZeroOrOne)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, final QueryContext ctx, Sequence[] args) {
        final Array array = (Array)args[0];
        if (array == null) {
            return null;
        }
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    private List<Sequence> sequences;
                    private Deque<Item> flatteningSequences = new ArrayDeque<Item>();
                    private int index;

                    @Override
                    public Item next() {
                        if (this.sequences == null) {
                            this.sequences = array.values();
                        } else if (!this.flatteningSequences.isEmpty()) {
                            return this.flatteningSequences.removeFirst();
                        }
                        if (this.index < this.sequences.size()) {
                            Sequence sequence;
                            if ((sequence = this.sequences.get(this.index++)) instanceof FlatteningSequence) {
                                Item item;
                                Iter iter = sequence.iterate();
                                while ((item = iter.next()) != null) {
                                    this.flatteningSequences.addLast(item.evaluateToItem(ctx, new TupleImpl()));
                                }
                                return this.flatteningSequences.removeFirst();
                            }
                            return (Item)sequence;
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }
}

