/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.annotation.FunctionAnnotation;

@FunctionAnnotation(description="Creates a collection.", parameters={"$name"})
public class Create
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "create");

    public Create() {
        this(DEFAULT_NAME);
    }

    public Create(QNm name) {
        super(name, new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String collection = ((Atomic)args[0]).stringValue();
            ctx.getNodeStore().create(collection);
            return null;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_CREATECOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }
}

