/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.serialize.StringSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class Silent
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "silent");

    public Silent() {
        this(DEFAULT_NAME);
    }

    public Silent(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.INR, Cardinality.One), SequenceType.ITEM_SEQUENCE), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Sequence sequence = args[0];
        if (sequence == null) {
            return Int32.ZERO;
        }
        CountStream out = new CountStream();
        try (StringSerializer serializer = new StringSerializer(new PrintWriter(out));){
            serializer.serialize(sequence);
        }
        return new Int64(out.count);
    }

    private static class CountStream
    extends OutputStream {
        long count = 0L;

        private CountStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
        }
    }
}

