/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class CodepointsToString
extends AbstractFunction {
    public CodepointsToString(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return Str.EMPTY;
        }
        Iter it = args[0].iterate();
        Item item = it.next();
        if (item == null) {
            return Str.EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        while (item != null) {
            int codePoint = ((IntNumeric)item).intValue();
            if (!(codePoint >= 32 && codePoint <= 55295 || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF)) {
                throw new QueryException(ErrorCode.ERR_CODE_POINT_NOT_VALID, "Codepoint does not represent a legal XML character: %s.", codePoint);
            }
            sb.append(Character.toChars(codePoint)[0]);
            item = it.next();
        }
        return new Str(sb.toString());
    }
}

