/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.Date;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Time;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class DateTime
extends AbstractFunction {
    public DateTime(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Date date = (Date)args[0];
        Time time = (Time)args[1];
        if (date == null || time == null) {
            return null;
        }
        DTD dateTimeTimezone = date.getTimezone();
        DTD timeTimezone = time.getTimezone();
        if (dateTimeTimezone != null) {
            if (timeTimezone == null || !dateTimeTimezone.eq(timeTimezone)) {
                throw new QueryException(ErrorCode.ERR_DATETIME_FUNCTION_DIFFERENT_TZ, "Arguments of function '%s' have different timezones", this.getName());
            }
        } else {
            dateTimeTimezone = timeTimezone;
        }
        return new io.brackit.query.atomic.DateTime(date.getYear(), date.getMonth(), date.getDay(), time.getHours(), date.getMinutes(), date.getMicros(), dateTimeTimezone);
    }
}

