/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.module.StaticContext;
import java.util.Arrays;

public class DeepEqual
extends AbstractFunction {
    public DeepEqual(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Str collation;
        if (args.length == 3 && !(collation = (Str)args[2]).stringValue().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", collation);
        }
        Sequence a = args[0];
        Sequence b = args[1];
        return DeepEqual.deepEquals(a, b);
    }

    public static Bool deepEquals(Sequence a, Sequence b) throws QueryException {
        if (a == null) {
            if (b == null) {
                return Bool.TRUE;
            }
            try (Iter it = b.iterate();){
                Bool bool = it.next() == null ? Bool.TRUE : Bool.FALSE;
                return bool;
            }
        }
        if (b == null) {
            try (Iter it = a.iterate();){
                Bool bool = it.next() == null ? Bool.TRUE : Bool.FALSE;
                return bool;
            }
        }
        try (Iter aIt = a.iterate();){
            Bool bool;
            Iter bIt = b.iterate();
            try {
                Item aItem;
                while ((aItem = aIt.next()) != null) {
                    Item bItem = bIt.next();
                    if (DeepEqual.deepEquals(aItem, bItem)) continue;
                    Bool bool2 = Bool.FALSE;
                    if (bIt != null) {
                        bIt.close();
                    }
                    return bool2;
                }
            }
            catch (Throwable throwable) {
                if (bIt != null) {
                    try {
                        bIt.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            Bool bool3 = bool = bIt.next() == null ? Bool.TRUE : Bool.FALSE;
            if (bIt != null) {
                bIt.close();
            }
            return bool;
        }
    }

    private static boolean deepEquals(Item a, Item b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Atomic) {
            if (!(b instanceof Atomic)) {
                return false;
            }
            return DeepEqual.atomicDeepEquals((Atomic)a, (Atomic)b);
        }
        if (!(b instanceof Node)) {
            return false;
        }
        try {
            return DeepEqual.nodeDeepEquals((Node)a, (Node)b);
        }
        catch (DocumentException e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_DOCUMENT_ACCESS_ERROR);
        }
    }

    private static boolean nodeDeepEquals(Node<?> a, Node<?> b) {
        Kind aKind = a.getKind();
        if (aKind != b.getKind()) {
            return false;
        }
        if (aKind == Kind.ELEMENT) {
            if (!a.getName().equals(b.getName())) {
                return false;
            }
            if (!DeepEqual.attributesDeepEqual(a, b).bool) {
                return false;
            }
            return DeepEqual.childrenDeepEqual(a, b);
        }
        if (aKind == Kind.ATTRIBUTE) {
            return a.getName().equals(b.getName()) && a.getValue().equals(b.getValue());
        }
        if (aKind == Kind.TEXT || aKind == Kind.COMMENT) {
            return a.getValue().equals(b.getValue());
        }
        if (aKind == Kind.DOCUMENT) {
            return DeepEqual.childrenDeepEqual(a, b);
        }
        if (aKind == Kind.PROCESSING_INSTRUCTION) {
            return a.getName().equals(b.getName()) && a.getValue().equals(b.getValue());
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected node kind: '%s'", new Object[]{aKind});
    }

    private static boolean childrenDeepEqual(Node<?> a, Node<?> b) {
        Object aChild = a.getFirstChild();
        Object bChild = b.getFirstChild();
        while (aChild != null && bChild != null) {
            while (aChild.getKind() != Kind.ELEMENT && aChild.getKind() != Kind.TEXT && (aChild = aChild.getNextSibling()) != null) {
            }
            while (bChild.getKind() != Kind.ELEMENT && bChild.getKind() != Kind.TEXT && (bChild = bChild.getNextSibling()) != null) {
            }
            if (aChild == null || bChild == null) continue;
            if (!DeepEqual.nodeDeepEquals(aChild, bChild)) {
                return false;
            }
            aChild = aChild.getNextSibling();
            bChild = bChild.getNextSibling();
        }
        return aChild == null && bChild == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bool attributesDeepEqual(Node<?> a, Node<?> b) throws DocumentException {
        Stream<?> aAttributes = a.getAttributes();
        Node[] allAAttributes = new Node[]{};
        int aSize = 0;
        try {
            Node att;
            while ((att = (Node)aAttributes.next()) != null) {
                if (aSize == allAAttributes.length) {
                    allAAttributes = Arrays.copyOf(allAAttributes, allAAttributes.length * 3 / 2 + 1);
                }
                allAAttributes[aSize++] = att;
            }
        }
        finally {
            aAttributes.close();
        }
        int bSize = 0;
        try (Stream<?> bAttributes = b.getAttributes();){
            Node bAttribute;
            while ((bAttribute = (Node)bAttributes.next()) != null) {
                boolean match = false;
                ++bSize;
                for (int i = 0; i < aSize; ++i) {
                    Node aAttribute = allAAttributes[i];
                    if (!aAttribute.getName().equals(bAttribute.getName()) || !aAttribute.getValue().equals(bAttribute.getValue())) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                Bool bool = Bool.FALSE;
                return bool;
            }
        }
        return aSize == bSize ? Bool.TRUE : Bool.FALSE;
    }

    private static boolean atomicDeepEquals(Atomic a, Atomic b) throws QueryException {
        try {
            return a.eq(b);
        }
        catch (QueryException e) {
            if (e.getCode().eq(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE)) {
                return false;
            }
            throw e;
        }
    }
}

