/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.StructuredItem;
import io.brackit.query.jdm.StructuredItemCollection;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.TemporalNodeCollection;
import io.brackit.query.module.StaticContext;

public class Doc
extends AbstractFunction {
    private final boolean retrieve;

    public Doc(QNm name, boolean retrieve, Signature signature) {
        super(name, signature, true);
        this.retrieve = retrieve;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return this.retrieve ? null : Bool.FALSE;
        }
        String name = ((Str)args[0]).stringValue();
        int revision = args.length == 2 ? ((Int32)args[1]).intValue() : -1;
        try {
            StructuredItem document;
            if (name.isEmpty()) {
                Node<?> document2 = ctx.getDefaultDocument();
                if (document2 == null) {
                    if (this.retrieve) {
                        throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "No default document defined.");
                    }
                    return Bool.FALSE;
                }
                return document2;
            }
            AnyURI uri = Doc.resolve(sctx, name);
            StructuredItemCollection collection = ctx.getNodeStore().lookup(uri.stringValue());
            long documents = collection.getDocumentCount();
            if (documents == 0L) {
                if (this.retrieve) {
                    throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Empty collection");
                }
                return Bool.FALSE;
            }
            if (documents > 1L) {
                throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Collection %s contains more than one document", name);
            }
            if (collection instanceof TemporalNodeCollection) {
                TemporalNodeCollection temporalNodeCollection = (TemporalNodeCollection)collection;
                document = temporalNodeCollection.getDocument(revision);
            } else {
                document = collection.getDocument();
            }
            if (document == null) {
                if (this.retrieve) {
                    throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Empty collection");
                }
                return Bool.FALSE;
            }
            if (this.retrieve) {
                return document;
            }
            return Bool.FALSE;
        }
        catch (DocumentException e) {
            if (this.retrieve) {
                throw new QueryException(e, ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Document '%s' not found.", name);
            }
            return Bool.FALSE;
        }
    }

    static AnyURI resolve(StaticContext sctx, AnyURI base, AnyURI relative) throws QueryException {
        if (relative.isAbsolute()) {
            return relative;
        }
        if (!(base != null || (base = sctx.getBaseURI()) != null && base.isAbsolute())) {
            return relative;
        }
        try {
            return relative.absolutize(base);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_FN_RESOLVE_URI, (Object)"Error resolving URI %s against base URI %s");
        }
    }

    static AnyURI resolve(StaticContext sctx, String relStr) throws QueryException {
        try {
            AnyURI relative = new AnyURI(relStr);
            return Doc.resolve(sctx, null, relative);
        }
        catch (DocumentException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_URI, "Invalid relative URI: %s", relStr);
        }
    }
}

