/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Date;
import io.brackit.query.atomic.DateTime;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Time;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class ExtractFromDateTime
extends AbstractFunction {
    private Source source;
    private Comp comp;

    public ExtractFromDateTime(QNm name, Source source, Comp comp, Signature signature) {
        super(name, signature, true);
        this.source = source;
        this.comp = comp;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        switch (this.source.ordinal()) {
            case 0: {
                DateTime dt = (DateTime)args[0];
                switch (this.comp.ordinal()) {
                    case 0: {
                        return new Int32(dt.getYear());
                    }
                    case 1: {
                        return new Int32(dt.getMonth());
                    }
                    case 2: {
                        return new Int32(dt.getDay());
                    }
                    case 3: {
                        return new Int32(dt.getHours());
                    }
                    case 4: {
                        return new Int32(dt.getMinutes());
                    }
                    case 5: {
                        return new Dbl((double)dt.getMicros() / 1000000.0);
                    }
                    case 6: {
                        return dt.getTimezone();
                    }
                }
            }
            case 1: {
                Date date = (Date)args[0];
                switch (this.comp.ordinal()) {
                    case 0: {
                        return new Int32(date.getYear());
                    }
                    case 1: {
                        return new Int32(date.getMonth());
                    }
                    case 2: {
                        return new Int32(date.getDay());
                    }
                    case 6: {
                        return date.getTimezone();
                    }
                }
            }
            case 2: {
                Time time = (Time)args[0];
                switch (this.comp.ordinal()) {
                    case 3: {
                        return new Int32(time.getHours());
                    }
                    case 4: {
                        return new Int32(time.getMinutes());
                    }
                    case 5: {
                        return new Dbl((double)time.getMicros() / 1000000.0);
                    }
                    case 6: {
                        return time.getTimezone();
                    }
                }
            }
        }
        return null;
    }

    public static enum Source {
        DATE_TIME,
        DATE,
        TIME;

    }

    public static enum Comp {
        YEAR,
        MONTH,
        DAY,
        HOURS,
        MINUTES,
        SECONDS,
        TIMEZONE;

    }
}

