/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractDuration;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.Type;
import io.brackit.query.module.StaticContext;

public class ExtractFromDuration
extends AbstractFunction {
    private Comp comp;

    public ExtractFromDuration(QNm name, Comp comp, Signature signature) {
        super(name, signature, true);
        this.comp = comp;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        AbstractDuration dur = (AbstractDuration)args[0];
        int value = 0;
        switch (this.comp.ordinal()) {
            case 0: {
                if (dur.type().instanceOf(Type.DTD)) {
                    return Int32.ZERO;
                }
                value = dur.getYears();
                break;
            }
            case 1: {
                if (dur.type().instanceOf(Type.DTD)) {
                    return Int32.ZERO;
                }
                value = dur.getMonths();
                break;
            }
            case 2: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return Int32.ZERO;
                }
                value = dur.getDays();
                break;
            }
            case 3: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return Int32.ZERO;
                }
                value = dur.getHours();
                break;
            }
            case 4: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return Int32.ZERO;
                }
                value = dur.getMinutes();
                break;
            }
            case 5: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return new Dbl(0.0);
                }
                double d = (double)dur.getMicros() / 1000000.0;
                if (dur.isNegative()) {
                    return new Dbl(d * -1.0);
                }
                return new Dbl(d);
            }
        }
        if (dur.isNegative()) {
            return new Int32(value * -1);
        }
        return new Int32(value);
    }

    public static enum Comp {
        YEARS,
        MONTHS,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS;

    }
}

