/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;

public class StringToCodepoints
extends AbstractFunction {
    public StringToCodepoints(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return null;
        }
        final String subject = ((Str)args[0]).stringValue();
        if (subject.isEmpty()) {
            return null;
        }
        return new LazySequence(){
            final String s;
            {
                this.s = subject;
            }

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    int index = 0;

                    @Override
                    public Item next() throws QueryException {
                        if (this.index == s.length()) {
                            return null;
                        }
                        return new Int32(s.codePointAt(this.index++));
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }
}

