/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.expr.Cast;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;

public class Subsequence
extends AbstractFunction {
    public Subsequence(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        final Sequence s = args[0];
        if (s == null) {
            return null;
        }
        IntNumeric tmp = Cast.asInteger(((Dbl)args[1]).round().doubleValue());
        if (tmp.cmp(Int32.ZERO) <= 0) {
            tmp = Int32.ONE;
        }
        final IntNumeric st = tmp;
        tmp = null;
        if (args.length == 3) {
            IntNumeric length = Cast.asInteger(((Dbl)args[2]).round().doubleValue());
            tmp = (IntNumeric)st.add(length);
        }
        final IntNumeric e = tmp;
        return new LazySequence(){
            final Sequence seq;
            final IntNumeric start;
            final IntNumeric end;
            {
                this.seq = s;
                this.start = st;
                this.end = e;
            }

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    private IntNumeric next;
                    private Iter it;
                    {
                        this.next = start;
                    }

                    @Override
                    public Item next() throws QueryException {
                        if (end != null) {
                            this.next = this.next.inc();
                            if (this.next.cmp(end) > 0) {
                                return null;
                            }
                        }
                        if (this.it == null) {
                            this.it = seq.iterate();
                            this.it.skip((IntNumeric)start.subtract(Int32.ONE));
                        }
                        return this.it.next();
                    }

                    @Override
                    public void close() {
                        if (this.it != null) {
                            this.it.close();
                        }
                    }
                };
            }
        };
    }
}

