/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class Substring
extends AbstractFunction {
    public Substring(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        double end;
        if (args[0] == null) {
            return Str.EMPTY;
        }
        String string = ((Str)args[0]).stringValue();
        double start = ((Numeric)args[1]).round().doubleValue();
        double d = end = args.length == 3 ? ((Numeric)args[2]).round().doubleValue() : (double)string.length();
        if (Double.isNaN(start) || Double.isNaN(end) || start == Double.NEGATIVE_INFINITY && end == Double.POSITIVE_INFINITY) {
            return Str.EMPTY;
        }
        int startPos = (int)Math.max(start, 1.0) - 1;
        int endPos = (int)Math.min(start + end - 1.0, (double)string.length());
        if (endPos <= startPos || endPos - startPos <= 0) {
            return Str.EMPTY;
        }
        return new Str(string.substring(startPos, endPos));
    }
}

