/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class SubstringMatch
extends AbstractFunction {
    private final Mode mode;

    public SubstringMatch(QNm name, Mode mode, Signature signature) {
        super(name, signature, true);
        this.mode = mode;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        String pattern;
        Str collation;
        if (args.length == 3 && !(collation = (Str)args[2]).stringValue().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", collation);
        }
        String str = args[0] != null ? ((Str)args[0]).stringValue() : "";
        String string = pattern = args[1] != null ? ((Str)args[1]).stringValue() : "";
        if (pattern.isEmpty()) {
            return Bool.TRUE;
        }
        if (str.isEmpty()) {
            return Bool.FALSE;
        }
        switch (this.mode.ordinal()) {
            case 0: {
                return str.contains(pattern) ? Bool.TRUE : Bool.FALSE;
            }
            case 1: {
                return str.startsWith(pattern) ? Bool.TRUE : Bool.FALSE;
            }
            case 2: {
                return str.endsWith(pattern) ? Bool.TRUE : Bool.FALSE;
            }
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR);
    }

    public static enum Mode {
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH;

    }
}

