/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class SubstringRelative
extends AbstractFunction {
    private boolean before;

    public SubstringRelative(QNm name, boolean before, Signature signature) {
        super(name, signature, true);
        this.before = before;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        String pattern;
        Str collation;
        if (args.length == 3 && !(collation = (Str)args[2]).stringValue().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", collation);
        }
        if (args[0] == null || args[1] == null) {
            return Str.EMPTY;
        }
        if (((Str)args[1]).stringValue().isEmpty()) {
            if (this.before) {
                return Str.EMPTY;
            }
            return args[0];
        }
        String target = ((Str)args[0]).stringValue();
        int pos = target.indexOf(pattern = ((Str)args[1]).stringValue());
        if (pos == -1) {
            return Str.EMPTY;
        }
        if (this.before) {
            return new Str(target.substring(0, pos));
        }
        return new Str(target.substring(pos + pattern.length()));
    }
}

