/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.io;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.ItemSequence;
import io.brackit.query.util.Regex;
import io.brackit.query.util.annotation.FunctionAnnotation;
import java.io.File;
import java.io.FileFilter;

@FunctionAnnotation(description="Lists all files in the given path. The optional filter pattern is evaluated according to fn:matches without additional flags, i.e., to match allfiles in a directory ending with \".xml\" you must use \"\\.xml$\" instead of a shell-like \"*.xml\"", parameters={"$path", "$pattern"})
public class Ls
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "ls");

    public Ls(boolean withFilter) {
        this(DEFAULT_NAME, withFilter);
    }

    public Ls(QNm name, boolean withFilter) {
        super(name, withFilter ? new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne)) : new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        File dir = new File(((Atomic)args[0]).stringValue());
        FileFilter filter = null;
        if (args.length > 1) {
            final String pattern = ((Atomic)args[1]).stringValue();
            filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    try {
                        if (pattern.isEmpty()) {
                            return true;
                        }
                        Sequence match = Regex.match(Regex.Mode.MATCH, pathname.getName(), pattern, null, null);
                        return match.booleanValue();
                    }
                    catch (QueryException e) {
                        return false;
                    }
                }
            };
        }
        File[] files = dir.listFiles(filter);
        Item[] res = new Str[files.length];
        for (int i = 0; i < files.length; ++i) {
            res[i] = new Str(files[i].toURI().toString());
        }
        return new ItemSequence(res);
    }
}

