/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.io;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.io.IOFun;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.annotation.FunctionAnnotation;
import io.brackit.query.util.io.IOUtils;
import io.brackit.query.util.io.URIHandler;
import java.io.IOException;

@FunctionAnnotation(description="Loads a resource as plain text.", parameters={"$path"})
public class Read
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "read");

    public Read() {
        this(DEFAULT_NAME);
    }

    public Read(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String uri = ((Atomic)args[0]).stringValue();
            String s = IOUtils.getStringFromInputStream(URIHandler.getInputStream(uri));
            return new Str(s);
        }
        catch (IOException e) {
            throw new QueryException(e, IOFun.IO_LOADFILE_INT_ERROR);
        }
    }
}

