/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.io;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.io.IOFun;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.io.URIHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class Writeline
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "writeline");

    public Writeline() {
        this(DEFAULT_NAME);
    }

    public Writeline(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.INR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany)), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[1] == null) {
            return Int32.ZERO;
        }
        try {
            IntNumeric count = Int32.ZERO;
            String uri = ((Atomic)args[0]).stringValue();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(URIHandler.getOutputStream(uri, true)));
            try (Iter it = args[1].iterate();){
                Item item;
                while ((item = it.next()) != null) {
                    out.write(item.toString());
                    out.write(10);
                    count = count.inc();
                }
            }
            out.close();
            return count;
        }
        catch (IOException e) {
            throw new QueryException(e, IOFun.IO_WRITEFILE_INT_ERROR);
        }
    }
}

