/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.json;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.StructuredItemCollection;
import io.brackit.query.jdm.json.JsonCollection;
import io.brackit.query.jdm.json.JsonStore;
import io.brackit.query.jdm.type.AnyJsonItemType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.jsonitem.ParserStream;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.annotation.FunctionAnnotation;
import io.brackit.query.util.io.URIHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

@FunctionAnnotation(description="Load (external) documents into a collection. If explicitly required or if the collection does not exist, a new collection will be created. ", parameters={"$name", "$resources", "$create-new"})
public final class Load
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://jsoniq.org/functions", "jn", "load");

    public Load(boolean createNew) {
        this(DEFAULT_NAME, createNew);
    }

    public Load(QNm name, boolean createNew) {
        super(name, createNew ? new Signature(new SequenceType(AnyJsonItemType.ANY_JSON_ITEM, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany)) : new Signature(new SequenceType(AnyJsonItemType.ANY_JSON_ITEM, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.BOOL, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            boolean createNew = args.length != 3 || args[2].booleanValue();
            String name = ((Atomic)args[0]).stringValue();
            Sequence resources = args[1];
            JsonStore s = ctx.getJsonItemStore();
            if (createNew) {
                this.create(s, name, resources);
            } else {
                try {
                    StructuredItemCollection coll = s.lookup(name);
                    this.add((JsonCollection<?>)coll, resources);
                }
                catch (DocumentException e) {
                    this.create(s, name, resources);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_ADDTOCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }

    private void add(JsonCollection<?> coll, Sequence resources) {
        if (resources instanceof Atomic) {
            Atomic atomic = (Atomic)resources;
            String stringValue = atomic.stringValue();
            try {
                coll.add(new String(URIHandler.getInputStream(stringValue).readAllBytes(), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try (ParserStream parsers = new ParserStream(resources);){
            String json;
            while ((json = parsers.next()) != null) {
                coll.add(json);
            }
        }
    }

    private void create(JsonStore store, String name, Sequence resources) {
        if (resources instanceof Atomic) {
            String r = ((Atomic)resources).stringValue();
            try {
                store.create(name, new String(URIHandler.getInputStream(r).readAllBytes(), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try (ParserStream parsers = new ParserStream(resources);){
            String json;
            while ((json = parsers.next()) != null) {
                store.create(name, json);
            }
        }
    }
}

