/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jdm.type;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.NodeType;

public final class DocumentType
extends NodeType {
    public static final DocumentType DOC = new DocumentType();
    private final ElementType elementType;

    public DocumentType() {
        this.elementType = null;
    }

    public DocumentType(ElementType elementType) {
        this.elementType = elementType;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public Kind getNodeKind() {
        return Kind.DOCUMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(Node<?> node) throws QueryException {
        if (this.elementType != null) {
            if (node.getKind() != Kind.DOCUMENT) {
                return false;
            }
            try (Stream<?> children = node.getChildren();){
                Node rootElem;
                while ((rootElem = (Node)children.next()) != null) {
                    if (rootElem.getKind() != Kind.ELEMENT) continue;
                    boolean bl = this.elementType.matches(rootElem);
                    return bl;
                }
            }
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Document node does not have a root element");
        }
        return node.getKind() == Kind.DOCUMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(Item item) throws QueryException {
        if (this.elementType != null) {
            if (((Node)item).getKind() != Kind.DOCUMENT) {
                return false;
            }
            try (Stream children = ((Node)item).getChildren();){
                Node rootElem;
                while ((rootElem = (Node)children.next()) != null) {
                    if (rootElem.getKind() != Kind.ELEMENT) continue;
                    boolean bl = this.elementType.matches(rootElem);
                    return bl;
                }
            }
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Document node does not have a root element");
        }
        return item instanceof Node && ((Node)item).getKind() == Kind.DOCUMENT;
    }

    public String toString() {
        return this.elementType != null ? String.format("document-node(\"%s\")", this.elementType) : "document-node()";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DocumentType)) {
            return false;
        }
        DocumentType t = (DocumentType)obj;
        return !(this.elementType == null ? t.elementType != null : t.elementType == null || !this.elementType.equals(t.elementType));
    }
}

