/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jdm.type;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.type.NodeType;

public final class ElementType
extends NodeType {
    public static final ElementType ELEMENT = new ElementType();
    private final QNm name;
    private final Type type;

    public ElementType() {
        this.name = null;
        this.type = null;
    }

    public ElementType(QNm name) {
        this.name = name;
        this.type = null;
    }

    public ElementType(QNm name, Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public QNm getQName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isWildcard() {
        return this.name == null;
    }

    @Override
    public Kind getNodeKind() {
        return Kind.ELEMENT;
    }

    @Override
    public boolean matches(Node<?> node) throws QueryException {
        return !(node.getKind() != Kind.ELEMENT || this.name != null && !this.name.eq(node.getName()) || this.type != null && !node.type().instanceOf(this.type));
    }

    public String toString() {
        return this.name != null ? (this.type == null ? String.format("element(\"%s\")", this.name) : String.format("element(\"%s\", \"%s\")", this.name, this.type)) : "element()";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElementType)) {
            return false;
        }
        ElementType t = (ElementType)obj;
        if (this.name == null ? t.name != null : t.name == null || !this.name.equals(t.name)) {
            return false;
        }
        return !(this.type == null ? t.type != null : t.type == null || !this.type.equals(t.type));
    }
}

