/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jdm.type;

import io.brackit.query.QueryException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.type.NodeType;

public final class PIType
extends NodeType {
    private final String piTarget;

    public PIType(String piTarget) {
        this.piTarget = piTarget;
    }

    public PIType() {
        this.piTarget = null;
    }

    @Override
    public Kind getNodeKind() {
        return Kind.PROCESSING_INSTRUCTION;
    }

    @Override
    public boolean matches(Node<?> node) throws QueryException {
        if (this.piTarget != null) {
            return node.getKind() == Kind.PROCESSING_INSTRUCTION && node.getName().stringValue().equals(this.piTarget);
        }
        return node.getKind() == Kind.PROCESSING_INSTRUCTION;
    }

    @Override
    public boolean matches(Item item) throws QueryException {
        if (this.piTarget != null) {
            return item instanceof Node && ((Node)item).getKind() == Kind.PROCESSING_INSTRUCTION && ((Node)item).getName().stringValue().equals(this.piTarget);
        }
        return item instanceof Node && ((Node)item).getKind() == Kind.PROCESSING_INSTRUCTION;
    }

    public String toString() {
        return this.piTarget != null ? String.format("processing-instruction(\"%s\")", this.piTarget) : "processing-instruction()";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PIType)) {
            return false;
        }
        PIType t = (PIType)obj;
        return !(this.piTarget == null ? t.piTarget != null : t.piTarget == null || !this.piTarget.equals(t.piTarget));
    }
}

