/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jsonitem;

import io.brackit.query.function.json.JSONParser;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.OperationNotSupportedException;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.json.JsonItem;
import io.brackit.query.jsonitem.AbstractJsonItemCollection;
import io.brackit.query.node.stream.ArrayStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;

public final class SimpleJsonCollection
extends AbstractJsonItemCollection<JsonItem> {
    private JsonItem[] docs;

    public SimpleJsonCollection(String name, JsonItem doc) {
        super(name);
        this.docs = new JsonItem[]{doc};
    }

    public SimpleJsonCollection(String name, JsonItem ... docs) {
        super(name);
        this.docs = docs;
    }

    @Override
    public void delete() throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void remove(long documentID) {
        throw new OperationNotSupportedException();
    }

    @Override
    public JsonItem getDocument() {
        if (this.docs.length == 1) {
            return this.docs[0];
        }
        throw new DocumentException("Illegal access to non-singular collection", new Object[0]);
    }

    @Override
    public Stream<? extends JsonItem> getDocuments() {
        return new ArrayStream<JsonItem>(this.docs);
    }

    @Override
    public JsonItem add(Path file) {
        JsonItem doc;
        try {
            doc = (JsonItem)new JSONParser(file.toRealPath(LinkOption.NOFOLLOW_LINKS).toString()).parse();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.docs = Arrays.copyOf(this.docs, this.docs.length + 1);
        this.docs[this.docs.length - 1] = doc;
        return doc;
    }

    @Override
    public JsonItem add(String json) {
        JsonItem doc = (JsonItem)new JSONParser(json).parse();
        this.docs = Arrays.copyOf(this.docs, this.docs.length + 1);
        this.docs[this.docs.length - 1] = doc;
        return doc;
    }

    @Override
    public long getDocumentCount() {
        return this.docs.length;
    }
}

