/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jsonitem.array;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.AbstractItem;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.type.ArrayType;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.FlatteningSequence;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public abstract class AbstractArray
extends AbstractItem
implements Array {
    @Override
    public ItemType itemType() throws QueryException {
        return ArrayType.ARRAY;
    }

    @Override
    public Atomic atomize() throws QueryException {
        throw new QueryException(ErrorCode.ERR_ITEM_HAS_NO_TYPED_VALUE, "The atomized value of array items is undefined");
    }

    @Override
    public boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value of array items is undefined.");
    }

    @Override
    public Iter iterate() {
        return new BaseIter(){
            private List<Sequence> sequences;
            private final Deque<Item> flatteningSequences = new ArrayDeque<Item>();
            private int index;

            @Override
            public Item next() {
                if (this.sequences == null) {
                    this.sequences = AbstractArray.this.values();
                } else if (!this.flatteningSequences.isEmpty()) {
                    return this.flatteningSequences.removeFirst();
                }
                if (this.index < this.sequences.size()) {
                    Sequence sequence;
                    if ((sequence = this.sequences.get(this.index++)) instanceof FlatteningSequence) {
                        try (Iter iter = sequence.iterate();){
                            Item item;
                            while ((item = iter.next()) != null) {
                                this.flatteningSequences.addLast(item);
                            }
                            Item item2 = this.flatteningSequences.removeFirst();
                            return item2;
                        }
                    }
                    return (Item)sequence;
                }
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public Iter.Split split(int min, int max) throws QueryException {
                return null;
            }
        };
    }
}

