/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jsonitem.object;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.jsonitem.array.DArray;
import io.brackit.query.jsonitem.object.AbstractObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.magicwerk.brownies.collections.GapList;

public final class ArrayObject
extends AbstractObject {
    private final List<QNm> fields;
    private final List<Sequence> vals;
    private final Map<QNm, Sequence> fieldsToVals;

    public ArrayObject(QNm[] fields, Sequence[] values) {
        this.fields = new GapList(Arrays.asList(fields));
        this.vals = new GapList(Arrays.asList(values));
        this.fieldsToVals = new HashMap<QNm, Sequence>();
        for (int i = 0; i < fields.length; ++i) {
            QNm field = fields[i];
            Sequence value = values[i];
            this.fieldsToVals.put(field, value);
        }
    }

    @Override
    public Object replace(QNm field, Sequence value) {
        Objects.requireNonNull(field);
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            QNm currentField = this.fields.get(i);
            if (!currentField.equals(field)) continue;
            this.vals.set(i, value);
            this.fieldsToVals.put(field, value);
            break;
        }
        return this;
    }

    @Override
    public Object rename(QNm field, QNm newFieldName) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(newFieldName);
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            QNm currentField = this.fields.get(i);
            if (!currentField.equals(field)) continue;
            this.fields.set(i, newFieldName);
            Sequence value = this.fieldsToVals.remove(field);
            this.fieldsToVals.put(newFieldName, value);
            break;
        }
        return this;
    }

    @Override
    public Object insert(QNm field, Sequence value) {
        if (this.fieldsToVals.containsKey(field)) {
            throw new QueryException(new QNm("Field already defined."));
        }
        this.fields.add(field);
        this.vals.add(value);
        this.fieldsToVals.put(field, value);
        return this;
    }

    @Override
    public Object remove(QNm field) {
        int index = 0;
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            QNm currentField = this.fields.get(i);
            if (!field.equals(currentField)) continue;
            index = i;
            break;
        }
        this.fields.remove(index);
        this.vals.remove(index);
        this.fieldsToVals.remove(field);
        return this;
    }

    @Override
    public Object remove(IntNumeric index) {
        return this.remove(index.intValue());
    }

    @Override
    public Object remove(int index) {
        if (index < 0 || index > this.vals.size() - 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        QNm field = this.fields.remove(index);
        this.vals.remove(index);
        this.fieldsToVals.remove(field);
        return this;
    }

    @Override
    public Sequence get(QNm field) {
        return this.fieldsToVals.get(field);
    }

    @Override
    public Sequence value(IntNumeric i) {
        try {
            return this.vals.get(i.intValue());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid field index: %s", i);
        }
    }

    @Override
    public Sequence value(int i) {
        try {
            return this.vals.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid field index: %s", i);
        }
    }

    @Override
    public Array names() {
        return new DArray(this.fields);
    }

    @Override
    public Array values() {
        return new DArray(this.vals);
    }

    @Override
    public QNm name(IntNumeric i) {
        try {
            return this.fields.get(i.intValue());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid field index: %s", i);
        }
    }

    @Override
    public QNm name(int i) {
        try {
            return this.fields.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid field index: %s", i);
        }
    }

    @Override
    public IntNumeric length() {
        int length = this.vals.size();
        return length <= 20 ? Int32.ZERO_TO_TWENTY[length] : new Int32(length);
    }

    @Override
    public int len() {
        return this.vals.size();
    }
}

