/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.module;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Type;
import java.util.HashMap;
import java.util.Map;

public class Types {
    protected final Map<QNm, Type> atomicTypes = new HashMap<QNm, Type>();

    public Type resolveSchemaType(QNm name) throws QueryException {
        throw new QueryException(ErrorCode.ERR_UNDEFINED_REFERENCE, "No schema import found for namespace '%s'", name.getNamespaceURI());
    }

    public Type resolveType(QNm name) throws QueryException {
        Type type = this.resolveInternal(name);
        if (type != null) {
            return type;
        }
        throw new QueryException(ErrorCode.ERR_UNDEFINED_REFERENCE, "Unknown type: '%s'", name);
    }

    public Type resolveAtomicType(QNm name) throws QueryException {
        Type type = this.resolveInternal(name);
        if (type != null) {
            return type;
        }
        throw new QueryException(ErrorCode.ERR_UNKNOWN_ATOMIC_SCHEMA_TYPE, "Unknown atomic schema type: '%s'", name);
    }

    private Type resolveInternal(QNm name) {
        if ("http://www.w3.org/2001/XMLSchema".equals(name.getNamespaceURI())) {
            for (Type type : Type.builtInTypes) {
                if (!type.getName().getLocalName().equals(name.getLocalName())) continue;
                return type;
            }
            return null;
        }
        return this.atomicTypes.get(name);
    }
}

