/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.module;

import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.Bits;
import io.brackit.query.expr.DeclVariable;
import io.brackit.query.expr.DefaultCtxItem;
import io.brackit.query.expr.DefaultCtxPos;
import io.brackit.query.expr.DefaultCtxSize;
import io.brackit.query.expr.Variable;
import io.brackit.query.jdm.type.SequenceType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Variables {
    protected final Map<QNm, Variable> vars = new TreeMap<QNm, Variable>();
    protected final DefaultCtxItem dftItem = new DefaultCtxItem();
    protected final DefaultCtxPos dftPos = new DefaultCtxPos(this.dftItem);
    protected final DefaultCtxSize dftSize = new DefaultCtxSize(this.dftItem);
    protected final List<Variables> imports = new LinkedList<Variables>();

    public boolean isDeclared(QNm name) {
        return this.vars.containsKey(name);
    }

    public DefaultCtxItem getDftCtxItem() {
        return this.dftItem;
    }

    public DefaultCtxPos getDftCtxPos() {
        return this.dftPos;
    }

    public DefaultCtxSize getDftCtxSize() {
        return this.dftSize;
    }

    public Variable resolve(QNm name) {
        Variable var = this.vars.get(name);
        if (var != null) {
            return var;
        }
        if (name.equals(Bits.FS_DOT)) {
            return this.dftItem;
        }
        if (name.equals(Bits.FS_POSITION)) {
            return this.dftPos;
        }
        if (name.equals(Bits.FS_LAST)) {
            return null;
        }
        for (Variables v : this.imports) {
            var = v.resolve(name);
            if (var == null) continue;
            return var;
        }
        return null;
    }

    public void importVariables(Variables variables) {
        this.imports.add(variables);
    }

    public DeclVariable declare(QNm name, SequenceType type, boolean external) {
        DeclVariable var = new DeclVariable(name, type);
        this.vars.put(name, var);
        return var;
    }

    public Collection<Variable> getDeclaredVariables() {
        return Collections.unmodifiableCollection(this.vars.values());
    }
}

