/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.AbstractItem;
import io.brackit.query.jdm.Axis;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.type.AttributeType;
import io.brackit.query.jdm.type.CommentType;
import io.brackit.query.jdm.type.DocumentType;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.NodeType;
import io.brackit.query.jdm.type.PIType;
import io.brackit.query.jdm.type.TextType;
import io.brackit.query.node.stream.AtomStream;
import io.brackit.query.node.stream.filter.Filter;
import io.brackit.query.node.stream.filter.FilteredStream;

public abstract class AbstractNode<E extends Node<E>>
extends AbstractItem
implements Node<E> {
    @Override
    public Stream<? extends E> getPath() {
        final AbstractNode node = this;
        return new Stream(){
            Node<? extends E> next;
            {
                this.next = node;
            }

            @Override
            public void close() {
            }

            public Object next() {
                if (this.next == null) {
                    return null;
                }
                Node deliver = this.next;
                this.next = deliver.getParent();
                return deliver;
            }
        };
    }

    @Override
    public final int cmp(Node<?> other) {
        int fragmentIDB;
        if (other == this) {
            return 0;
        }
        int fragmentIDA = this.getNodeClassID();
        if (fragmentIDA == (fragmentIDB = other.getNodeClassID())) {
            return this.cmpInternal(other);
        }
        return fragmentIDA < fragmentIDB ? -1 : 1;
    }

    protected abstract int cmpInternal(E var1);

    @Override
    public Stream<? extends E> getDescendantOrSelf() {
        return new FilteredStream(this.getSubtree(), new AttributeFilter());
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return true;
    }

    @Override
    public AnyURI getBaseURI() {
        return null;
    }

    @Override
    public Stream<Atomic> getValues() {
        return new AtomStream<Atomic>(this.getValue());
    }

    @Override
    public Str getStrValue() {
        if (this.getKind() == Kind.ELEMENT || this.getKind() == Kind.DOCUMENT) {
            StringBuilder buffer = new StringBuilder();
            try (Stream<E> scanner = this.getDescendantOrSelf();){
                Node descendant;
                while ((descendant = (Node)scanner.next()) != null) {
                    if (descendant.getKind() != Kind.TEXT) continue;
                    buffer.append(descendant.getValue());
                }
            }
            return new Str(buffer.toString());
        }
        return this.getValue().asStr();
    }

    @Override
    public Type type() {
        return switch (this.getKind()) {
            case Kind.ELEMENT -> Type.UN;
            case Kind.ATTRIBUTE, Kind.TEXT -> Type.UNA;
            default -> null;
        };
    }

    @Override
    public ItemType itemType() {
        return switch (this.getKind()) {
            case Kind.ELEMENT -> new ElementType(this.getName(), Type.UN);
            case Kind.ATTRIBUTE -> new AttributeType(this.getName(), Type.UNA);
            case Kind.TEXT -> new TextType();
            case Kind.COMMENT -> new CommentType();
            case Kind.PROCESSING_INSTRUCTION -> new PIType();
            case Kind.DOCUMENT -> new DocumentType();
            default -> null;
        };
    }

    @Override
    public Stream<? extends Node<?>> performStep(Axis axis, NodeType test) {
        return null;
    }

    @Override
    public Atomic atomize() throws QueryException {
        return this.getValue();
    }

    public final boolean equals(Object obj) {
        return obj instanceof Node && this.isSelfOf((Node)obj);
    }

    private static class AttributeFilter
    implements Filter<Node<?>> {
        private AttributeFilter() {
        }

        @Override
        public boolean filter(Node<?> node) {
            return node.getKind() == Kind.ATTRIBUTE;
        }
    }
}

