/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeFactory;
import io.brackit.query.node.d2linked.AttributeD2Node;
import io.brackit.query.node.d2linked.CommentD2Node;
import io.brackit.query.node.d2linked.D2Node;
import io.brackit.query.node.d2linked.D2NodeBuilder;
import io.brackit.query.node.d2linked.D2NodeCollection;
import io.brackit.query.node.d2linked.DocumentD2Node;
import io.brackit.query.node.d2linked.ElementD2Node;
import io.brackit.query.node.d2linked.PID2Node;
import io.brackit.query.node.d2linked.TextD2Node;
import io.brackit.query.node.parser.NavigationalSubtreeParser;
import io.brackit.query.node.parser.NodeSubtreeParser;

public class D2NodeFactory
implements NodeFactory<D2Node> {
    @Override
    public D2Node attribute(QNm name, Atomic value) throws DocumentException {
        return new AttributeD2Node(name, value);
    }

    @Override
    public D2Node comment(Str value) throws DocumentException {
        return new CommentD2Node(value);
    }

    @Override
    public D2Node document(Str name) throws DocumentException {
        String s = name != null ? name.stringValue() : null;
        return new DocumentD2Node(s);
    }

    @Override
    public D2Node element(QNm name) throws DocumentException {
        return new ElementD2Node(name);
    }

    @Override
    public D2Node pi(QNm target, Str value) throws DocumentException {
        return new PID2Node(target, value);
    }

    @Override
    public D2Node text(Atomic value) throws DocumentException {
        return new TextD2Node(value);
    }

    @Override
    public D2Node copy(Node<?> source) throws DocumentException {
        return this.build(new NavigationalSubtreeParser(source));
    }

    @Override
    public D2Node build(NodeSubtreeParser parser) throws DocumentException {
        D2NodeBuilder handler = new D2NodeBuilder();
        parser.parse(handler);
        return (D2Node)handler.root();
    }

    @Override
    public NodeCollection<D2Node> collection(String name, NodeSubtreeParser parser) throws DocumentException {
        D2NodeCollection coll = new D2NodeCollection(name);
        D2NodeBuilder builder = new D2NodeBuilder(coll);
        parser.parse(builder);
        return coll;
    }

    @Override
    public NodeCollection<D2Node> collection(String name, Stream<NodeSubtreeParser> parsers) throws DocumentException {
        D2NodeCollection coll = new D2NodeCollection(name);
        D2NodeBuilder builder = new D2NodeBuilder(coll);
        try (Stream<NodeSubtreeParser> stream = parsers;){
            NodeSubtreeParser parser;
            while ((parser = parsers.next()) != null) {
                parser.parse(builder);
            }
        }
        return coll;
    }

    @Override
    public NodeCollection<D2Node> collection(String name) throws DocumentException {
        return new D2NodeCollection(name);
    }
}

