/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.node.d2linked.AttributeD2Node;
import io.brackit.query.node.d2linked.D2Node;
import io.brackit.query.node.d2linked.DocumentD2Node;
import io.brackit.query.node.d2linked.ElementD2Node;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.node.parser.NodeSubtreeParser;
import java.util.Map;

public class D2NodeParser
implements NodeSubtreeParser {
    private final D2Node root;

    public D2NodeParser(D2Node root) {
        this.root = root;
    }

    @Override
    public void parse(NodeSubtreeHandler handler) throws DocumentException {
        try {
            handler.begin();
            handler.beginFragment();
            this.traverse(handler, this.root);
            handler.endFragment();
            handler.end();
        }
        catch (DocumentException e) {
            handler.fail();
            throw e;
        }
    }

    private void traverse(NodeSubtreeHandler handler, D2Node node) throws DocumentException {
        Kind kind = node.getKind();
        if (kind == Kind.ELEMENT) {
            ElementD2Node elem = (ElementD2Node)node;
            if (elem.nsMappings != null) {
                for (Map.Entry<String, String> entry : elem.nsMappings.entrySet()) {
                    handler.startMapping(entry.getKey(), entry.getValue());
                }
            }
            handler.startElement(elem.name);
            Object n = elem.firstAttribute;
            while (n != null) {
                AttributeD2Node attributeD2Node = (AttributeD2Node)n;
                handler.attribute(attributeD2Node.name, attributeD2Node.value);
                n = ((D2Node)n).sibling;
            }
            n = elem.firstChild;
            while (n != null) {
                this.traverse(handler, (D2Node)n);
                n = ((D2Node)n).sibling;
            }
            handler.endElement(elem.name);
            if (elem.nsMappings != null) {
                for (Map.Entry entry : elem.nsMappings.entrySet()) {
                    handler.endMapping((String)entry.getKey());
                }
            }
        } else if (kind == Kind.TEXT) {
            handler.text(node.getValue());
        } else if (kind == Kind.COMMENT) {
            handler.comment(node.getStrValue());
        } else if (kind == Kind.PROCESSING_INSTRUCTION) {
            handler.processingInstruction(node.getName(), node.getStrValue());
        } else if (kind == Kind.ATTRIBUTE) {
            handler.attribute(node.getName(), node.getValue());
        } else if (kind == Kind.DOCUMENT) {
            handler.startDocument();
            DocumentD2Node doc = (DocumentD2Node)node;
            D2Node n = doc.firstChild;
            while (n != null) {
                this.traverse(handler, n);
                n = n.sibling;
            }
            handler.endDocument();
        } else {
            throw new DocumentException("Illegal node type: %s", new Object[]{kind});
        }
    }
}

