/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Scope;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.d2linked.AttributeD2Node;
import io.brackit.query.node.d2linked.D2Node;
import io.brackit.query.node.d2linked.ParentD2Node;
import io.brackit.query.node.stream.EmptyStream;
import io.brackit.query.node.stream.IteratorStream;
import java.util.Map;
import java.util.TreeMap;

public final class ElementD2Node
extends ParentD2Node
implements Scope {
    Map<String, String> nsMappings;
    QNm name;
    D2Node firstAttribute;

    public ElementD2Node(QNm name) throws DocumentException {
        super(null, FIRST);
        this.name = this.checkName(name);
    }

    ElementD2Node(ParentD2Node parent, int[] division, QNm name) throws DocumentException {
        super(parent, division);
        this.name = this.checkName(name);
    }

    QNm checkName(QNm name) throws DocumentException {
        String newPrefix;
        if (name.getPrefix() == null || name.getPrefix().isEmpty()) {
            return name;
        }
        String mappedUri = this.resolvePrefix(name.getPrefix());
        String uri = name.getNamespaceURI();
        if (mappedUri == null) {
            this.addPrefix(name.getPrefix(), uri);
            return name;
        }
        if (mappedUri.equals(uri)) {
            return name;
        }
        if (this.nsMappings == null) {
            name = new QNm(uri, name.getPrefix() + "_1", name.getLocalName());
            this.addPrefix(name.getPrefix(), uri);
            return name;
        }
        int i = 1;
        do {
            if ((mappedUri = this.nsMappings.get(newPrefix = name.getPrefix() + "_" + i++)) != null) continue;
            name = new QNm(uri, newPrefix, name.getLocalName());
            this.addPrefix(name.getPrefix(), uri);
            return name;
        } while (!mappedUri.equals(uri));
        name = new QNm(uri, newPrefix, name.getLocalName());
        return name;
    }

    @Override
    public QNm getName() throws DocumentException {
        return this.name;
    }

    @Override
    public Kind getKind() {
        return Kind.ELEMENT;
    }

    @Override
    public D2Node getAttribute(QNm name) throws DocumentException {
        D2Node attribute = this.firstAttribute;
        while (attribute != null) {
            if (attribute.getName().equals(name)) {
                return attribute;
            }
            attribute = attribute.sibling;
        }
        return null;
    }

    @Override
    protected boolean hasAttribute(D2Node attribute) {
        D2Node myAttribute = this.firstAttribute;
        while (myAttribute != null) {
            if (attribute == myAttribute) {
                return true;
            }
            myAttribute = myAttribute.sibling;
        }
        return false;
    }

    @Override
    public Stream<D2Node> getAttributes() throws DocumentException {
        if (this.firstAttribute == null) {
            return new EmptyStream<D2Node>();
        }
        return new ParentD2Node.SiblingStream(this.firstAttribute);
    }

    @Override
    public D2Node getNextSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.nextSiblingOf(this);
    }

    @Override
    public Stream<? extends D2Node> getDescendantOrSelf() throws DocumentException {
        return new ParentD2Node.DescendantScanner(this);
    }

    @Override
    public D2Node getPreviousSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.previousSiblingOf(this);
    }

    @Override
    public boolean hasAttributes() throws DocumentException {
        return this.firstAttribute != null;
    }

    @Override
    public boolean deleteAttribute(QNm name) throws DocumentException {
        D2Node prev = null;
        D2Node attribute = this.firstAttribute;
        while (attribute != null) {
            if (attribute.getName().equals(name)) {
                if (prev != null) {
                    prev.sibling = attribute.sibling;
                } else {
                    this.firstAttribute = attribute.sibling;
                }
                return true;
            }
            prev = attribute;
            attribute = attribute.sibling;
        }
        return false;
    }

    @Override
    public D2Node setAttribute(Node<?> attribute) throws DocumentException {
        if (attribute.getKind() != Kind.ATTRIBUTE) {
            throw new DocumentException("Cannot set nodes of type '%s' as attribute", new Object[]{attribute.getKind()});
        }
        return this.setAttribute(attribute.getName(), attribute.getValue());
    }

    @Override
    public D2Node setAttribute(QNm name, Atomic value) throws DocumentException {
        this.checkName(name);
        if (this.firstAttribute == null) {
            this.firstAttribute = new AttributeD2Node(this, name, value);
            return this.firstAttribute;
        }
        D2Node prev = null;
        D2Node attribute = this.firstAttribute;
        while (attribute != null) {
            if (attribute.getName().equals(name)) {
                throw new DocumentException("Attribute '%s' already exists.", name);
            }
            prev = attribute;
            attribute = attribute.sibling;
        }
        prev.sibling = new AttributeD2Node(this, this.siblingAfter(prev.division), name, value);
        return prev.sibling;
    }

    @Override
    public void setName(QNm name) throws DocumentException {
        this.name = this.checkName(name);
    }

    @Override
    public void setValue(Atomic value) throws DocumentException {
        this.firstChild = null;
        this.append(Kind.TEXT, null, value);
    }

    @Override
    public Scope getScope() {
        return this;
    }

    @Override
    public Stream<String> localPrefixes() throws DocumentException {
        if (this.nsMappings == null) {
            return new EmptyStream<String>();
        }
        return new IteratorStream<String>(this.nsMappings.keySet());
    }

    @Override
    public void addPrefix(String prefix, String uri) throws DocumentException {
        if (this.nsMappings == null) {
            this.nsMappings = new TreeMap<String, String>();
        }
        this.nsMappings.put(prefix, uri);
    }

    @Override
    public String defaultNS() throws DocumentException {
        return this.resolvePrefix("");
    }

    @Override
    public void setDefaultNS(String uri) throws DocumentException {
        this.addPrefix("", uri);
    }

    @Override
    public String resolvePrefix(String prefix) throws DocumentException {
        if (prefix == null) {
            prefix = "";
        }
        ElementD2Node n = this;
        while (true) {
            String uri;
            if (n.nsMappings != null && (uri = n.nsMappings.get(prefix)) != null) {
                return uri;
            }
            ParentD2Node p = n.parent;
            if (!(p instanceof ElementD2Node)) break;
            n = (ElementD2Node)p;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return prefix.isEmpty() ? "" : null;
    }

    public String toString() {
        return String.format("(type='%s', name='%s', value='%s')", new Object[]{Kind.ELEMENT, this.name, null});
    }
}

