/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Una;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.d2linked.CommentD2Node;
import io.brackit.query.node.d2linked.D2Node;
import io.brackit.query.node.d2linked.D2NodeBuilder;
import io.brackit.query.node.d2linked.ElementD2Node;
import io.brackit.query.node.d2linked.PID2Node;
import io.brackit.query.node.d2linked.TextD2Node;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.node.stream.EmptyStream;

abstract class ParentD2Node
extends D2Node {
    protected D2Node firstChild;

    @Override
    public Stream<D2Node> getSubtree() throws DocumentException {
        return new FragmentScanner(this);
    }

    protected ParentD2Node(ParentD2Node parent, int[] division) {
        super(parent, division);
    }

    protected boolean hasAttribute(D2Node attribute) {
        return false;
    }

    @Override
    public Atomic getValue() throws DocumentException {
        StringBuilder buffer = new StringBuilder();
        try (DescendantScanner scanner = new DescendantScanner(this);){
            D2Node descendant;
            while ((descendant = (D2Node)scanner.next()) != null) {
                if (descendant.getKind() != Kind.TEXT) continue;
                buffer.append(descendant.getValue());
            }
        }
        return new Una(buffer.toString());
    }

    D2Node nextSiblingOf(D2Node node) {
        return node.sibling;
    }

    D2Node previousSiblingOf(D2Node node) {
        if (node == this.firstChild) {
            return null;
        }
        D2Node child = this.firstChild;
        while (child != null) {
            if (child.sibling == node) {
                return child;
            }
            child = child.sibling;
        }
        return null;
    }

    void deleteChild(D2Node node) throws DocumentException {
        if (this.getKind() == Kind.DOCUMENT && node.getKind() == Kind.ELEMENT) {
            throw new DocumentException("The root element must not be deleted", new Object[0]);
        }
        D2Node prev = this.previousSiblingOf(node);
        if (prev == null) {
            this.firstChild = node.sibling;
        } else {
            prev.sibling = node.sibling;
        }
    }

    D2Node insertChild(D2Node sibling, Kind kind, QNm name, Atomic value, boolean right) throws DocumentException {
        D2Node ns;
        if (this.getKind() == Kind.DOCUMENT && kind == Kind.ELEMENT) {
            D2Node c = this.firstChild;
            while (c != null) {
                if (c.getKind() == Kind.ELEMENT) {
                    throw new DocumentException("Document nodes must have only one root element", new Object[0]);
                }
                c = c.sibling;
            }
        }
        if (this.firstChild == null) {
            this.firstChild = this.buildChild(null, null, kind, name, value);
            return this.firstChild;
        }
        D2Node ps = null;
        if (sibling == null) {
            if (right) {
                ps = this.firstChild;
                while (ps.sibling != null) {
                    ps = ps.sibling;
                }
                ns = null;
            } else {
                ns = this.firstChild;
            }
        } else if (right) {
            ps = sibling;
            ns = sibling.sibling;
        } else {
            ns = sibling;
            if (this.firstChild != sibling) {
                ps = this.firstChild;
                while (ps.sibling != sibling) {
                    ps = ps.sibling;
                }
            }
        }
        if (kind == Kind.TEXT) {
            if (ps != null && ps.getKind() == Kind.TEXT) {
                ps.setValue(new Una(ps.getValue().stringValue() + value.stringValue()));
                return ps;
            }
            if (ns != null && ns.getKind() == Kind.TEXT) {
                ns.setValue(new Una(ns.getValue().stringValue() + value.stringValue()));
                return ns;
            }
        }
        int[] psd = ps != null ? ps.division : null;
        int[] nsd = ns != null ? ns.division : null;
        D2Node c = this.buildChild(psd, nsd, kind, name, value);
        c.sibling = ns;
        if (ps == null) {
            this.firstChild = c;
        } else {
            ps.sibling = c;
        }
        return c;
    }

    private D2Node replaceChild(D2Node sibling, Kind kind, QNm name, Atomic value) throws DocumentException {
        if (this.getKind() == Kind.DOCUMENT && sibling != null && sibling.getKind() == Kind.ELEMENT && kind != Kind.ELEMENT) {
            throw new DocumentException("Cannot replace root element with of kind: %s", new Object[]{kind});
        }
        D2Node previous = this.firstChild;
        while (previous.sibling != null && previous.sibling != sibling) {
            previous = previous.sibling;
        }
        assert (sibling != null);
        D2Node child = this.buildChild(sibling.division, kind, name, value);
        child.sibling = sibling.sibling;
        previous.sibling = child;
        return child;
    }

    private D2Node buildChild(int[] prevSibling, int[] nextSibling, Kind kind, QNm name, Atomic value) throws DocumentException {
        int[] division = prevSibling != null ? (nextSibling != null ? this.siblingBetween(prevSibling, nextSibling) : this.siblingAfter(prevSibling)) : (nextSibling != null ? this.siblingBefore(nextSibling) : FIRST);
        return this.buildChild(division, kind, name, value);
    }

    private D2Node buildChild(int[] division, Kind kind, QNm name, Atomic value) throws DocumentException {
        D2Node child;
        if (kind == Kind.ELEMENT) {
            child = new ElementD2Node(this, division, name);
        } else if (kind == Kind.TEXT) {
            child = new TextD2Node(this, division, value);
        } else if (kind == Kind.COMMENT) {
            child = new CommentD2Node(this, division, value);
        } else if (kind == Kind.PROCESSING_INSTRUCTION) {
            child = new PID2Node(this, division, name, value);
        } else {
            throw new DocumentException("Illegal child node kind: %s", new Object[]{kind});
        }
        return child;
    }

    @Override
    public D2Node append(Kind kind, QNm name, Atomic value) throws DocumentException {
        return this.insertChild(null, kind, name, value, true);
    }

    @Override
    public D2Node append(Node<?> child) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, null, true);
        child.parse(builder);
        return (D2Node)builder.root();
    }

    @Override
    public D2Node append(NodeSubtreeParser parser) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, null, true);
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    @Override
    public Stream<D2Node> getChildren() throws DocumentException {
        if (this.firstChild == null) {
            return new EmptyStream<D2Node>();
        }
        return new SiblingStream(this.firstChild);
    }

    @Override
    public D2Node getFirstChild() throws DocumentException {
        return this.firstChild;
    }

    @Override
    public D2Node getLastChild() throws DocumentException {
        if (this.firstChild == null) {
            return null;
        }
        D2Node child = this.firstChild;
        while (child.sibling != null) {
            child = child.sibling;
        }
        return child;
    }

    @Override
    public boolean hasChildren() throws DocumentException {
        return this.firstChild != null;
    }

    @Override
    public boolean isAncestorOf(Node<?> node) {
        D2Node d2Node;
        return node instanceof D2Node && (d2Node = (D2Node)node).isInSubtreeOf(this);
    }

    @Override
    public boolean isAncestorOrSelfOf(Node<?> node) {
        D2Node d2Node;
        return node == this || node instanceof D2Node && (d2Node = (D2Node)node).isInSubtreeOf(this);
    }

    @Override
    public boolean isParentOf(Node<?> node) {
        return node != null && (node.isChildOf(this) || node.isAttributeOf(this));
    }

    @Override
    public D2Node prepend(Kind kind, QNm name, Atomic value) throws DocumentException {
        return this.insertChild(null, kind, name, value, true);
    }

    @Override
    public D2Node prepend(Node<?> child) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, null, false);
        child.parse(builder);
        return (D2Node)builder.root();
    }

    @Override
    public D2Node prepend(NodeSubtreeParser parser) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, null, false);
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    D2Node insertBefore(D2Node node, Kind kind, QNm name, Atomic value) throws DocumentException {
        return this.insertChild(node, kind, name, value, true);
    }

    D2Node insertBefore(D2Node node, Node<?> child) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, node, false);
        child.parse(builder);
        return (D2Node)builder.root();
    }

    D2Node insertBefore(D2Node node, NodeSubtreeParser parser) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, node, false);
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    D2Node insertAfter(D2Node node, Kind kind, QNm name, Atomic value) throws DocumentException {
        return this.insertChild(node, kind, name, value, false);
    }

    D2Node insertAfter(D2Node node, Node<?> child) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, node, true);
        child.parse(builder);
        return (D2Node)builder.root();
    }

    D2Node insertAfter(D2Node node, NodeSubtreeParser parser) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(this, node, true);
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    D2Node replace(D2Node node, Kind kind, QNm name, Atomic value) throws DocumentException {
        return this.replaceChild(node, kind, name, value);
    }

    D2Node replace(D2Node node, Node<?> child) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        final ParentD2Node me = this;
        D2NodeBuilder builder = new D2NodeBuilder(){

            @Override
            D2Node first(Kind kind, QNm name, Atomic value) throws DocumentException {
                return ParentD2Node.this.replace(me, kind, name, value);
            }
        };
        child.parse(builder);
        return (D2Node)builder.root();
    }

    D2Node replace(D2Node node, NodeSubtreeParser parser) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        final ParentD2Node me = this;
        D2NodeBuilder builder = new D2NodeBuilder(){

            @Override
            D2Node first(Kind kind, QNm name, Atomic value) throws DocumentException {
                return ParentD2Node.this.replace(me, kind, name, value);
            }
        };
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    private static final class FragmentScanner
    implements Stream<D2Node> {
        D2Node current;
        D2Node first;
        D2Node root;
        boolean inAttribute;

        public FragmentScanner(D2Node root) {
            this.root = root;
            this.current = root;
            this.first = root;
        }

        @Override
        public void close() {
            this.current = null;
        }

        @Override
        public D2Node next() throws DocumentException {
            D2Node next;
            if (this.current == null) {
                return null;
            }
            if (this.first != null) {
                D2Node deliver = this.first;
                this.first = null;
                return deliver;
            }
            if (this.current instanceof ElementD2Node && (next = ((ElementD2Node)this.current).firstAttribute) != null) {
                this.inAttribute = true;
                this.current = next;
                return next;
            }
            if (this.current instanceof ParentD2Node && (next = ((ParentD2Node)this.current).firstChild) != null) {
                this.current = next;
                return next;
            }
            while (this.current != this.root) {
                next = this.current.sibling;
                if (next != null) {
                    this.current = next;
                    return next;
                }
                this.current = this.current.parent;
                if (!this.inAttribute) continue;
                this.inAttribute = false;
                next = ((ParentD2Node)this.current).firstChild;
                if (next == null) continue;
                this.current = next;
                return next;
            }
            return null;
        }
    }

    protected static final class DescendantScanner
    implements Stream<D2Node> {
        D2Node current;
        D2Node root;
        boolean first;

        public DescendantScanner(D2Node root) {
            this.current = root;
            this.first = true;
            this.root = root;
        }

        @Override
        public void close() {
            this.current = null;
        }

        @Override
        public D2Node next() throws DocumentException {
            D2Node next;
            if (this.first) {
                this.first = false;
                return this.root;
            }
            if (this.current instanceof ParentD2Node && (next = ((ParentD2Node)this.current).firstChild) != null) {
                this.current = next;
                return next;
            }
            while (this.current != this.root) {
                next = this.current.sibling;
                if (next != null) {
                    this.current = next;
                    return next;
                }
                this.current = this.current.parent;
            }
            return null;
        }
    }

    protected static class SiblingStream
    implements Stream<D2Node> {
        D2Node node;

        SiblingStream(D2Node first) {
            this.node = first;
        }

        @Override
        public void close() {
            this.node = null;
        }

        @Override
        public D2Node next() throws DocumentException {
            if (this.node == null) {
                return null;
            }
            D2Node deliver = this.node;
            this.node = this.node.sibling;
            return deliver;
        }
    }
}

