/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.dom;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.dom.AttrImpl;
import io.brackit.query.node.dom.CommentImpl;
import io.brackit.query.node.dom.DocumentImpl;
import io.brackit.query.node.dom.ElementImpl;
import io.brackit.query.node.dom.NodeImpl;
import io.brackit.query.node.dom.ProcInstrImpl;
import io.brackit.query.node.dom.TextImpl;
import io.brackit.query.node.parser.DefaultListener;
import io.brackit.query.node.parser.NodeSubtreeListener;
import java.util.ArrayDeque;
import java.util.Deque;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMListener
extends DefaultListener<Node<?>>
implements NodeSubtreeListener<Node<?>> {
    protected DocumentImpl document;
    protected final Deque<NodeImpl> stack = new ArrayDeque<NodeImpl>();

    @Override
    public void startDocument() throws DocumentException {
        if (this.document != null) {
            throw new DocumentException("Multiple documents are not supported", new Object[0]);
        }
        this.document = new DocumentImpl();
        this.stack.clear();
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public <T extends Node<?>> void attribute(T node) throws DocumentException {
        org.w3c.dom.Node current = this.stack.peekLast();
        assert (current != null);
        ((Element)current).setAttributeNode(new AttrImpl(this.document, current, node.getName().stringValue(), node.getValue().stringValue()));
    }

    @Override
    public <T extends Node<?>> void startElement(T node) throws DocumentException {
        NodeImpl current = this.stack.peekLast();
        ElementImpl newChild = new ElementImpl(this.document, current, node.getName().stringValue(), null);
        if (current != null) {
            ((Element)((Object)current)).appendChild(newChild);
        } else {
            this.document.setDocumentElement(newChild);
        }
        this.stack.addLast(newChild);
    }

    @Override
    public <T extends Node<?>> void endElement(T node) throws DocumentException {
        this.stack.pop();
    }

    @Override
    public <T extends Node<?>> void text(T node) throws DocumentException {
        this.insertText(node.getValue().stringValue());
    }

    @Override
    public <T extends Node<?>> void comment(T node) throws DocumentException {
        this.insertComment(node.getValue().stringValue());
    }

    @Override
    public <T extends Node<?>> void processingInstruction(T node) throws DocumentException {
        this.insertProcessingInstruction(node.getValue().stringValue());
    }

    private void insertText(String text) throws DocumentException {
        NodeImpl current = this.stack.peekLast();
        assert (current != null);
        current.appendChild(new TextImpl(this.document, current, null, text));
    }

    private void insertProcessingInstruction(String value) {
        NodeImpl current = this.stack.peekLast();
        assert (current != null);
        current.appendChild(new ProcInstrImpl(this.document, current, null, value));
    }

    private void insertComment(String value) {
        NodeImpl current = this.stack.peekLast();
        assert (current != null);
        current.appendChild(new CommentImpl(this.document, current, null, value));
    }
}

