/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.parser;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.parser.NodeSubtreeListener;
import io.brackit.query.util.log.Logger;
import java.util.ArrayList;
import java.util.List;

public abstract class NodeSubtreeProcessor<E extends Node<E>> {
    private static final Logger log = Logger.getLogger(NodeSubtreeProcessor.class);
    private final List<NodeSubtreeListener<? super E>> listeners = new ArrayList<NodeSubtreeListener<? super E>>();

    public NodeSubtreeProcessor(List<NodeSubtreeListener<? super E>> listeners) {
        if (listeners != null) {
            for (NodeSubtreeListener<E> nodeSubtreeListener : listeners) {
                this.listeners.add(nodeSubtreeListener);
            }
        }
    }

    protected void notifyBegin() throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.begin();
        }
    }

    protected void notifyEnd() throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.end();
        }
    }

    protected void notifyBeginDocument() throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.startDocument();
        }
    }

    protected void notifyEndDocument() throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.endDocument();
        }
    }

    protected void notifyBeginFragment() throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.beginFragment();
        }
    }

    protected void notifyEndFragment() throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.endFragment();
        }
    }

    protected void notifyFail() {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            try {
                listener.fail();
            }
            catch (DocumentException e) {
                log.error(e);
            }
        }
    }

    protected void notifyStartElement(E node) throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.startElement(node);
        }
    }

    protected void notifyEndElement(E node) throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.endElement(node);
        }
    }

    protected void notifyAttribute(E node) throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.attribute(node);
        }
    }

    protected void notifyText(E node) throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.text(node);
        }
    }

    protected void notifyComment(E node) throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.comment(node);
        }
    }

    protected void notifyProcessingInstruction(E node) throws DocumentException {
        for (NodeSubtreeListener<E> listener : this.listeners) {
            listener.processingInstruction(node);
        }
    }
}

