/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.parser;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.parser.DocumentParser;
import io.brackit.query.node.parser.NodeStreamSubtreeParser;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.util.io.URIHandler;
import java.io.IOException;

public final class ParserStream
implements Stream<NodeSubtreeParser> {
    private final Iter it;

    public ParserStream(Sequence locs) {
        this.it = locs.iterate();
    }

    @Override
    public NodeSubtreeParser next() throws DocumentException {
        try {
            Item item = this.it.next();
            if (item == null) {
                return null;
            }
            if (item instanceof Atomic) {
                String str = ((Atomic)item).stringValue();
                return new DocumentParser(URIHandler.getInputStream(str));
            }
            if (item instanceof Node) {
                Node n = (Node)item;
                return new NodeStreamSubtreeParser(n.getSubtree());
            }
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create subtree parser for item of type: %s", item.itemType());
        }
        catch (QueryException | IOException e) {
            throw new DocumentException(e);
        }
    }

    @Override
    public void close() {
        this.it.close();
    }
}

