/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.operator.Check;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.Operator;

public class ForBind
extends Check
implements Operator {
    final Operator in;
    final Expr bind;
    final boolean allowingEmpty;
    boolean bindVar = true;
    boolean bindPos = false;

    public ForBind(Operator in, Expr bind, boolean allowingEmpty) {
        this.in = in;
        this.bind = bind;
        this.allowingEmpty = allowingEmpty;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) {
        return new ForBindCursor(this.in.create(ctx, tuple));
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) {
        return new ForBindCursor(this.in.create(ctx, buf, len));
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize) + (this.bindVar ? 1 : 0) + (this.bindPos ? 1 : 0);
    }

    public void bindVariable(boolean bindVariable) {
        this.bindVar = bindVariable;
    }

    public void bindPosition(boolean bindPos) {
        this.bindPos = bindPos;
    }

    private class ForBindCursor
    implements Cursor {
        private final Cursor c;
        private IntNumeric pos;
        private Tuple t;
        private Iter it;

        public ForBindCursor(Cursor c) {
            this.c = c;
        }

        @Override
        public void close(QueryContext ctx) {
            if (this.it != null) {
                this.it.close();
            }
            this.it = null;
            this.c.close(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) {
            do {
                if (this.it != null) {
                    Item item = this.it.next();
                    if (item != null) {
                        return this.emit(this.t, item);
                    }
                    this.it.close();
                    this.it = null;
                }
                if ((this.t = this.c.next(ctx)) == null) {
                    return null;
                }
                if (ForBind.this.check && ForBind.this.dead(this.t)) {
                    Tuple tmp = this.passthrough(this.t);
                    this.t = null;
                    return tmp;
                }
                Sequence s = ForBind.this.bind.evaluate(ctx, this.t);
                this.pos = Int32.ZERO;
                if (s == null) {
                    Tuple tmp = ForBind.this.allowingEmpty ? this.emit(this.t, null) : (ForBind.this.check ? this.passthroughUncheck(this.t, ForBind.this.local()) : null);
                    this.t = null;
                    return tmp;
                }
                if (s instanceof Item && !(s instanceof Array)) {
                    return this.emit(this.t, s);
                }
                this.it = s.iterate();
                Item i = this.it.next();
                if (i != null) {
                    return this.emit(this.t, i);
                }
                this.it.close();
                this.it = null;
                if (!ForBind.this.allowingEmpty) continue;
                Tuple tmp = this.emit(i, null);
                this.t = null;
                return tmp;
            } while (!ForBind.this.check);
            Tuple tmp = this.passthroughUncheck(this.t, ForBind.this.local());
            this.t = null;
            return tmp;
        }

        private Tuple emit(Tuple t, Sequence item) {
            if (ForBind.this.bindVar) {
                if (ForBind.this.bindPos) {
                    return t.concat(new Sequence[]{item, item != null ? (this.pos = this.pos.inc()) : this.pos});
                }
                return t.concat(item);
            }
            if (ForBind.this.bindPos) {
                return t.concat(item != null ? (this.pos = this.pos.inc()) : this.pos);
            }
            return t;
        }

        private Tuple passthrough(Tuple t) {
            if (ForBind.this.bindVar) {
                if (ForBind.this.bindPos) {
                    return t.concat(new Sequence[2]);
                }
                return t.concat((Sequence)null);
            }
            if (ForBind.this.bindPos) {
                return t.concat((Sequence)null);
            }
            return t;
        }

        private Tuple passthroughUncheck(Tuple t, int check) {
            if (ForBind.this.bindVar) {
                if (ForBind.this.bindPos) {
                    return t.conreplace(new Sequence[2], check, null);
                }
                return t.conreplace((Sequence)null, check, null);
            }
            if (ForBind.this.bindPos) {
                return t.conreplace((Sequence)null, check, null);
            }
            return t;
        }

        @Override
        public void open(QueryContext ctx) {
            if (this.it != null) {
                throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "ForBind already opened");
            }
            this.c.open(ctx);
        }
    }
}

