/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.Operator;
import io.brackit.query.util.Cmp;
import java.util.Arrays;

public class NLJoin
implements Operator {
    final Operator l;
    final Operator r;
    final Expr rExpr;
    final Expr lExpr;
    final boolean leftJoin;
    final Cmp cmp;
    final boolean isGCmp;

    public NLJoin(Operator l, Operator r, Expr lExpr, Expr rExpr, Cmp cmp, boolean isGCmp, boolean leftJoin) {
        this.l = l;
        this.r = r;
        this.rExpr = rExpr;
        this.lExpr = lExpr;
        this.cmp = cmp;
        this.isGCmp = isGCmp;
        this.leftJoin = leftJoin;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) {
        int lSize = this.l.tupleWidth(tuple.getSize());
        int pad = this.r.tupleWidth(tuple.getSize()) - tuple.getSize();
        return new NLJoinCursor(this.l.create(ctx, tuple), lSize, pad);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) {
        int lSize = this.l.tupleWidth(buf[0].getSize());
        int pad = this.r.tupleWidth(buf[0].getSize()) - buf[0].getSize();
        return new NLJoinCursor(this.l.create(ctx, buf, len), lSize, pad);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.l.tupleWidth(initSize) + this.r.tupleWidth(initSize) - initSize;
    }

    private class NLJoinCursor
    implements Cursor {
        private final Cursor lc;
        private final int lSize;
        private final Sequence[] padding;
        private Tuple lt;
        private Sequence lKey;
        private boolean lMatch;
        private Cursor rc;

        private NLJoinCursor(Cursor lc, int lSize, int pad) {
            this.lc = lc;
            this.lSize = lSize;
            this.padding = new Sequence[pad];
        }

        @Override
        public void open(QueryContext ctx) {
            this.lc.open(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) {
            do {
                Tuple rt;
                if (this.rc == null) {
                    this.lt = this.lc.next(ctx);
                    if (this.lt == null) {
                        return null;
                    }
                    this.lMatch = false;
                    this.lKey = NLJoin.this.isGCmp ? NLJoin.this.lExpr.evaluate(ctx, this.lt) : NLJoin.this.lExpr.evaluateToItem(ctx, this.lt);
                    this.rc = NLJoin.this.r.create(ctx, this.lt);
                    this.rc.open(ctx);
                }
                while ((rt = this.rc.next(ctx)) != null) {
                    Sequence rKey = NLJoin.this.isGCmp ? NLJoin.this.rExpr.evaluate(ctx, rt) : NLJoin.this.rExpr.evaluateToItem(ctx, rt);
                    boolean res = NLJoin.this.isGCmp ? NLJoin.this.cmp.gCmp(ctx, this.lKey, rKey) : NLJoin.this.cmp.vCmp(ctx, (Item)this.lKey, (Item)rKey);
                    if (!res) continue;
                    Sequence[] tmp = rt.array();
                    Sequence[] bindings = Arrays.copyOfRange(tmp, this.lSize, tmp.length);
                    this.lMatch = true;
                    return this.lt.concat(bindings);
                }
                this.rc.close(ctx);
                this.rc = null;
            } while (!NLJoin.this.leftJoin || this.lMatch);
            return this.lt.concat(this.padding);
        }

        @Override
        public void close(QueryContext ctx) {
            if (this.rc != null) {
                this.rc.close(ctx);
            }
            this.lc.close(ctx);
        }
    }
}

