/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.Operator;

public class Parallelizer
implements Operator {
    private final Operator in;

    public Parallelizer(Operator in) {
        this.in = in;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        return new ParallelizerCursor(this.in.create(ctx, tuple), ctx);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        return new ParallelizerCursor(this.in.create(ctx, buf, len), ctx);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize);
    }

    private static class ParallelizerCursor
    implements Cursor {
        private final Cursor c;
        private final QueryContext ctx;
        private volatile boolean finished;
        private volatile QueryException error;
        private Tuple current;
        private Tuple[] currentBuffer;
        private Tuple[][] freeQueue;
        private volatile int freeQueueStart;
        private volatile int freeQueueEnd;
        private int pos = 0;

        ParallelizerCursor(Cursor c, QueryContext ctx) {
            this.c = c;
            this.ctx = ctx;
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            int noOfBuffers = 3;
            this.freeQueue = new Tuple[noOfBuffers][2000];
            this.finished = false;
            this.freeQueueStart = noOfBuffers - 1;
            this.freeQueueEnd = 0;
            new Thread(() -> this.fill()).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fill() {
            try {
                Tuple t;
                this.c.open(this.ctx);
                int pos = 0;
                Tuple[] buffer = this.freeQueue[0];
                int length = buffer.length;
                while ((t = this.c.next(this.ctx)) != null) {
                    buffer[pos++] = t;
                    if (pos != length) continue;
                    if (this.finished) break;
                    buffer = this.enqueue();
                    length = buffer.length;
                    pos = 0;
                }
                this.enqueue();
                this.finished = true;
            }
            catch (QueryException e) {
                this.error = e;
                this.finished = true;
            }
            finally {
                this.c.close(this.ctx);
            }
        }

        private Tuple[] enqueue() {
            int queueStart = this.freeQueueStart;
            int queueEnd = this.freeQueueEnd;
            int newQueueEnd = (queueEnd + 1) % this.freeQueue.length;
            while (newQueueEnd == queueStart) {
                queueStart = this.freeQueueStart;
            }
            this.freeQueueEnd = newQueueEnd;
            return this.freeQueue[newQueueEnd];
        }

        private Tuple[] dequeue() {
            int queueStart = this.freeQueueStart;
            int queueEnd = this.freeQueueEnd;
            int newQueueStart = (queueStart + 1) % this.freeQueue.length;
            while (newQueueStart == queueEnd) {
                queueEnd = this.freeQueueEnd;
            }
            this.freeQueueStart = newQueueStart;
            return this.freeQueue[newQueueStart];
        }

        @Override
        public void close(QueryContext ctx) {
            this.finished = true;
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            QueryException deliverError = this.error;
            if (deliverError != null) {
                this.error = null;
                throw deliverError;
            }
            if (this.currentBuffer == null || this.pos == this.currentBuffer.length) {
                this.currentBuffer = this.dequeue();
                this.pos = 0;
            }
            this.current = this.currentBuffer[this.pos];
            this.currentBuffer[this.pos++] = null;
            if (this.current == null) {
                return null;
            }
            Tuple deliver = this.current;
            this.current = null;
            return deliver;
        }
    }
}

