/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.Operator;
import java.io.PrintStream;
import java.util.Arrays;

public class Print
implements Operator {
    private final Operator in;
    private final PrintStream out;

    public Print(Operator in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        return new PrintCursor(this.in.create(ctx, tuple), new Tuple[]{tuple}, this.out);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        return new PrintCursor(this.in.create(ctx, buf, len), buf, this.out);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize);
    }

    public String asString(QueryContext ctx, Sequence sequence) throws QueryException {
        return sequence.toString();
    }

    protected class PrintCursor
    implements Cursor {
        private static final int MAX_SIZE = 20;
        private final Cursor c;
        private final Tuple[] t;
        private final PrintStream out;
        private int count;

        public PrintCursor(Cursor c, Tuple[] t, PrintStream out) {
            this.c = c;
            this.t = t;
            this.out = out;
        }

        @Override
        public void close(QueryContext ctx) {
            this.c.close(ctx);
            this.out.println("---");
            this.out.print(this.count);
            this.out.println(" results");
            this.out.flush();
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            Tuple next = this.c.next(ctx);
            if (next != null) {
                ++this.count;
                int size = next.getSize();
                this.out.print("|");
                for (int i = 0; i < size; ++i) {
                    this.out.print(' ');
                    Sequence sequence = next.get(i);
                    String s = sequence != null ? Print.this.asString(ctx, sequence) : "()";
                    s = this.shrinkOrPad(s);
                    this.out.print(s);
                    this.out.print(" |");
                }
                this.out.print('\n');
            }
            return next;
        }

        private String shrinkOrPad(String s) {
            int length = s.length();
            if (length == 20) {
                return s;
            }
            if (length > 20) {
                return s.substring(0, 20);
            }
            int toAdd = 20 - length;
            char[] result = new char[20];
            int i = 0;
            while (i < toAdd / 2) {
                result[i++] = 32;
            }
            System.arraycopy(s.toCharArray(), 0, result, i, length);
            int j = i + length;
            while (i++ < toAdd) {
                result[j++] = 32;
            }
            return new String(result);
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.c.open(ctx);
            this.count = 0;
            this.out.print("--- ");
            this.out.println(Arrays.toString(this.t));
        }
    }
}

