/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Sequence;
import java.util.Arrays;

public final class TupleImpl
implements Tuple {
    public static final Tuple EMPTY_TUPLE = new TupleImpl();
    private final Sequence[] sequences;

    public TupleImpl() {
        this.sequences = new Sequence[0];
    }

    public TupleImpl(Sequence t) {
        this.sequences = new Sequence[]{t};
    }

    public TupleImpl(Sequence[] t) {
        this.sequences = Arrays.copyOf(t, t.length);
    }

    @Override
    public Tuple project(int ... positions) {
        Sequence[] projected = new Sequence[positions.length];
        int targetPos = 0;
        for (int pos : positions) {
            projected[targetPos++] = this.get(pos);
        }
        return new TupleImpl(projected);
    }

    @Override
    public Tuple project(int start, int end) {
        if (start < 0 || start >= this.sequences.length) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, start);
        }
        if (end < start || end >= this.sequences.length) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, end);
        }
        return new TupleImpl(Arrays.copyOfRange(this.sequences, start, end));
    }

    @Override
    public Tuple replace(int position, Sequence s) {
        if (position < 0 || position >= this.sequences.length) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        Sequence[] tmp = Arrays.copyOf(this.sequences, this.sequences.length);
        tmp[position] = s;
        return new TupleImpl(tmp);
    }

    @Override
    public Tuple concat(Sequence s) {
        Sequence[] tmp = Arrays.copyOf(this.sequences, this.sequences.length + 1);
        tmp[this.sequences.length] = s;
        return new TupleImpl(tmp);
    }

    @Override
    public Tuple concat(Sequence[] s) {
        Sequence[] tmp = Arrays.copyOf(this.sequences, this.sequences.length + s.length);
        System.arraycopy(s, 0, tmp, this.sequences.length, s.length);
        return new TupleImpl(tmp);
    }

    @Override
    public Tuple conreplace(Sequence con, int position, Sequence s) {
        int nLen = this.sequences.length + 1;
        if (position < 0 || position >= nLen) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        Sequence[] tmp = Arrays.copyOf(this.sequences, nLen);
        tmp[this.sequences.length] = s;
        tmp[position] = s;
        return new TupleImpl(tmp);
    }

    @Override
    public Tuple conreplace(Sequence[] con, int position, Sequence s) {
        int nLen = this.sequences.length + con.length;
        if (position < 0 || position >= nLen) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        Sequence[] tmp = Arrays.copyOf(this.sequences, nLen);
        System.arraycopy(con, 0, tmp, this.sequences.length, con.length);
        tmp[position] = s;
        return new TupleImpl(tmp);
    }

    @Override
    public Sequence[] array() {
        return this.sequences;
    }

    @Override
    public Sequence get(int position) {
        if (position < 0 || position >= this.sequences.length) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        return this.sequences[position];
    }

    @Override
    public int getSize() {
        return this.sequences.length;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        for (int i = 0; i < this.sequences.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.sequences[i]);
        }
        out.append("]");
        return out.toString();
    }
}

